/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Targeting represents different criteria that can be used by advertisers to target ad inventory.
 * For example, they can choose to target ad requests only if the user is in the US. Multiple types
 * of targeting are always applied as a logical AND, unless noted otherwise.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MarketplaceTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Geo criteria IDs to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CriteriaTargeting geoTargeting;

  /**
   * Inventory sizes to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InventorySizeTargeting inventorySizeTargeting;

  /**
   * Placement targeting information, e.g., URL, mobile applications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlacementTargeting placementTargeting;

  /**
   * Technology targeting information, e.g., operating system, device category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TechnologyTargeting technologyTargeting;

  /**
   * Video targeting information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoTargeting videoTargeting;

  /**
   * Geo criteria IDs to be included/excluded.
   * @return value or {@code null} for none
   */
  public CriteriaTargeting getGeoTargeting() {
    return geoTargeting;
  }

  /**
   * Geo criteria IDs to be included/excluded.
   * @param geoTargeting geoTargeting or {@code null} for none
   */
  public MarketplaceTargeting setGeoTargeting(CriteriaTargeting geoTargeting) {
    this.geoTargeting = geoTargeting;
    return this;
  }

  /**
   * Inventory sizes to be included/excluded.
   * @return value or {@code null} for none
   */
  public InventorySizeTargeting getInventorySizeTargeting() {
    return inventorySizeTargeting;
  }

  /**
   * Inventory sizes to be included/excluded.
   * @param inventorySizeTargeting inventorySizeTargeting or {@code null} for none
   */
  public MarketplaceTargeting setInventorySizeTargeting(InventorySizeTargeting inventorySizeTargeting) {
    this.inventorySizeTargeting = inventorySizeTargeting;
    return this;
  }

  /**
   * Placement targeting information, e.g., URL, mobile applications.
   * @return value or {@code null} for none
   */
  public PlacementTargeting getPlacementTargeting() {
    return placementTargeting;
  }

  /**
   * Placement targeting information, e.g., URL, mobile applications.
   * @param placementTargeting placementTargeting or {@code null} for none
   */
  public MarketplaceTargeting setPlacementTargeting(PlacementTargeting placementTargeting) {
    this.placementTargeting = placementTargeting;
    return this;
  }

  /**
   * Technology targeting information, e.g., operating system, device category.
   * @return value or {@code null} for none
   */
  public TechnologyTargeting getTechnologyTargeting() {
    return technologyTargeting;
  }

  /**
   * Technology targeting information, e.g., operating system, device category.
   * @param technologyTargeting technologyTargeting or {@code null} for none
   */
  public MarketplaceTargeting setTechnologyTargeting(TechnologyTargeting technologyTargeting) {
    this.technologyTargeting = technologyTargeting;
    return this;
  }

  /**
   * Video targeting information.
   * @return value or {@code null} for none
   */
  public VideoTargeting getVideoTargeting() {
    return videoTargeting;
  }

  /**
   * Video targeting information.
   * @param videoTargeting videoTargeting or {@code null} for none
   */
  public MarketplaceTargeting setVideoTargeting(VideoTargeting videoTargeting) {
    this.videoTargeting = videoTargeting;
    return this;
  }

  @Override
  public MarketplaceTargeting set(String fieldName, Object value) {
    return (MarketplaceTargeting) super.set(fieldName, value);
  }

  @Override
  public MarketplaceTargeting clone() {
    return (MarketplaceTargeting) super.clone();
  }

}
