/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Terms for Private Auctions. Note that Private Auctions can be created only by the seller, but
 * they can be returned in a get or list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NonGuaranteedAuctionTerms extends com.google.api.client.json.GenericJson {

  /**
   * True if open auction buyers are allowed to compete with invited buyers in this private auction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoOptimizePrivateAuction;

  /**
   * Reserve price for the specified buyer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PricePerBuyer> reservePricesPerBuyer;

  /**
   * True if open auction buyers are allowed to compete with invited buyers in this private auction.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoOptimizePrivateAuction() {
    return autoOptimizePrivateAuction;
  }

  /**
   * True if open auction buyers are allowed to compete with invited buyers in this private auction.
   * @param autoOptimizePrivateAuction autoOptimizePrivateAuction or {@code null} for none
   */
  public NonGuaranteedAuctionTerms setAutoOptimizePrivateAuction(java.lang.Boolean autoOptimizePrivateAuction) {
    this.autoOptimizePrivateAuction = autoOptimizePrivateAuction;
    return this;
  }

  /**
   * Reserve price for the specified buyer.
   * @return value or {@code null} for none
   */
  public java.util.List<PricePerBuyer> getReservePricesPerBuyer() {
    return reservePricesPerBuyer;
  }

  /**
   * Reserve price for the specified buyer.
   * @param reservePricesPerBuyer reservePricesPerBuyer or {@code null} for none
   */
  public NonGuaranteedAuctionTerms setReservePricesPerBuyer(java.util.List<PricePerBuyer> reservePricesPerBuyer) {
    this.reservePricesPerBuyer = reservePricesPerBuyer;
    return this;
  }

  @Override
  public NonGuaranteedAuctionTerms set(String fieldName, Object value) {
    return (NonGuaranteedAuctionTerms) super.set(fieldName, value);
  }

  @Override
  public NonGuaranteedAuctionTerms clone() {
    return (NonGuaranteedAuctionTerms) super.clone();
  }

}
