/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A proposal may be associated to several notes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Note extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The timestamp for when this note was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The role of the person (buyer/seller) creating the note.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorRole;

  /**
   * The actual note to attach. (max-length: 1024 unicode code units) Note: This field may be set
   * only when creating the resource. Modifying this field while updating the resource will result
   * in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String note;

  /**
   * Output only. The unique ID for the note.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String noteId;

  /**
   * Output only. The revision number of the proposal when the note is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long proposalRevision;

  /**
   * Output only. The timestamp for when this note was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The timestamp for when this note was created.
   * @param createTime createTime or {@code null} for none
   */
  public Note setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The role of the person (buyer/seller) creating the note.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorRole() {
    return creatorRole;
  }

  /**
   * Output only. The role of the person (buyer/seller) creating the note.
   * @param creatorRole creatorRole or {@code null} for none
   */
  public Note setCreatorRole(java.lang.String creatorRole) {
    this.creatorRole = creatorRole;
    return this;
  }

  /**
   * The actual note to attach. (max-length: 1024 unicode code units) Note: This field may be set
   * only when creating the resource. Modifying this field while updating the resource will result
   * in an error.
   * @return value or {@code null} for none
   */
  public java.lang.String getNote() {
    return note;
  }

  /**
   * The actual note to attach. (max-length: 1024 unicode code units) Note: This field may be set
   * only when creating the resource. Modifying this field while updating the resource will result
   * in an error.
   * @param note note or {@code null} for none
   */
  public Note setNote(java.lang.String note) {
    this.note = note;
    return this;
  }

  /**
   * Output only. The unique ID for the note.
   * @return value or {@code null} for none
   */
  public java.lang.String getNoteId() {
    return noteId;
  }

  /**
   * Output only. The unique ID for the note.
   * @param noteId noteId or {@code null} for none
   */
  public Note setNoteId(java.lang.String noteId) {
    this.noteId = noteId;
    return this;
  }

  /**
   * Output only. The revision number of the proposal when the note is created.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProposalRevision() {
    return proposalRevision;
  }

  /**
   * Output only. The revision number of the proposal when the note is created.
   * @param proposalRevision proposalRevision or {@code null} for none
   */
  public Note setProposalRevision(java.lang.Long proposalRevision) {
    this.proposalRevision = proposalRevision;
    return this;
  }

  @Override
  public Note set(String fieldName, Object value) {
    return (Note) super.set(fieldName, value);
  }

  @Override
  public Note clone() {
    return (Note) super.clone();
  }

}
