/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Represents targeting information for operating systems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperatingSystemTargeting extends com.google.api.client.json.GenericJson {

  /**
   * IDs of operating systems to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CriteriaTargeting operatingSystemCriteria;

  /**
   * IDs of operating system versions to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CriteriaTargeting operatingSystemVersionCriteria;

  /**
   * IDs of operating systems to be included/excluded.
   * @return value or {@code null} for none
   */
  public CriteriaTargeting getOperatingSystemCriteria() {
    return operatingSystemCriteria;
  }

  /**
   * IDs of operating systems to be included/excluded.
   * @param operatingSystemCriteria operatingSystemCriteria or {@code null} for none
   */
  public OperatingSystemTargeting setOperatingSystemCriteria(CriteriaTargeting operatingSystemCriteria) {
    this.operatingSystemCriteria = operatingSystemCriteria;
    return this;
  }

  /**
   * IDs of operating system versions to be included/excluded.
   * @return value or {@code null} for none
   */
  public CriteriaTargeting getOperatingSystemVersionCriteria() {
    return operatingSystemVersionCriteria;
  }

  /**
   * IDs of operating system versions to be included/excluded.
   * @param operatingSystemVersionCriteria operatingSystemVersionCriteria or {@code null} for none
   */
  public OperatingSystemTargeting setOperatingSystemVersionCriteria(CriteriaTargeting operatingSystemVersionCriteria) {
    this.operatingSystemVersionCriteria = operatingSystemVersionCriteria;
    return this;
  }

  @Override
  public OperatingSystemTargeting set(String fieldName, Object value) {
    return (OperatingSystemTargeting) super.set(fieldName, value);
  }

  @Override
  public OperatingSystemTargeting clone() {
    return (OperatingSystemTargeting) super.clone();
  }

}
