/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Request message to pause serving for finalized deals.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PauseProposalDealsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The external_deal_id's of the deals to be paused. If empty, all the deals in the proposal will
   * be paused.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> externalDealIds;

  /**
   * The reason why the deals are being paused. This human readable message will be displayed in the
   * seller's UI. (Max length: 1000 unicode code units.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The external_deal_id's of the deals to be paused. If empty, all the deals in the proposal will
   * be paused.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExternalDealIds() {
    return externalDealIds;
  }

  /**
   * The external_deal_id's of the deals to be paused. If empty, all the deals in the proposal will
   * be paused.
   * @param externalDealIds externalDealIds or {@code null} for none
   */
  public PauseProposalDealsRequest setExternalDealIds(java.util.List<java.lang.String> externalDealIds) {
    this.externalDealIds = externalDealIds;
    return this;
  }

  /**
   * The reason why the deals are being paused. This human readable message will be displayed in the
   * seller's UI. (Max length: 1000 unicode code units.)
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason why the deals are being paused. This human readable message will be displayed in the
   * seller's UI. (Max length: 1000 unicode code units.)
   * @param reason reason or {@code null} for none
   */
  public PauseProposalDealsRequest setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  @Override
  public PauseProposalDealsRequest set(String fieldName, Object value) {
    return (PauseProposalDealsRequest) super.set(fieldName, value);
  }

  @Override
  public PauseProposalDealsRequest clone() {
    return (PauseProposalDealsRequest) super.clone();
  }

}
