/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Represents targeting about where the ads can appear, e.g., certain sites or mobile applications.
 * Different placement targeting types will be logically OR'ed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlacementTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Mobile application targeting information in a deal. This doesn't apply to Auction Packages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MobileApplicationTargeting mobileApplicationTargeting;

  /**
   * URLs to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlTargeting urlTargeting;

  /**
   * Mobile application targeting information in a deal. This doesn't apply to Auction Packages.
   * @return value or {@code null} for none
   */
  public MobileApplicationTargeting getMobileApplicationTargeting() {
    return mobileApplicationTargeting;
  }

  /**
   * Mobile application targeting information in a deal. This doesn't apply to Auction Packages.
   * @param mobileApplicationTargeting mobileApplicationTargeting or {@code null} for none
   */
  public PlacementTargeting setMobileApplicationTargeting(MobileApplicationTargeting mobileApplicationTargeting) {
    this.mobileApplicationTargeting = mobileApplicationTargeting;
    return this;
  }

  /**
   * URLs to be included/excluded.
   * @return value or {@code null} for none
   */
  public UrlTargeting getUrlTargeting() {
    return urlTargeting;
  }

  /**
   * URLs to be included/excluded.
   * @param urlTargeting urlTargeting or {@code null} for none
   */
  public PlacementTargeting setUrlTargeting(UrlTargeting urlTargeting) {
    this.urlTargeting = urlTargeting;
    return this;
  }

  @Override
  public PlacementTargeting set(String fieldName, Object value) {
    return (PlacementTargeting) super.set(fieldName, value);
  }

  @Override
  public PlacementTargeting clone() {
    return (PlacementTargeting) super.clone();
  }

}
