/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Represents a price and a pricing type for a product / deal.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Price extends com.google.api.client.json.GenericJson {

  /**
   * The actual price with currency specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money amount;

  /**
   * The pricing type for the deal/product. (default: CPM)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pricingType;

  /**
   * The actual price with currency specified.
   * @return value or {@code null} for none
   */
  public Money getAmount() {
    return amount;
  }

  /**
   * The actual price with currency specified.
   * @param amount amount or {@code null} for none
   */
  public Price setAmount(Money amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The pricing type for the deal/product. (default: CPM)
   * @return value or {@code null} for none
   */
  public java.lang.String getPricingType() {
    return pricingType;
  }

  /**
   * The pricing type for the deal/product. (default: CPM)
   * @param pricingType pricingType or {@code null} for none
   */
  public Price setPricingType(java.lang.String pricingType) {
    this.pricingType = pricingType;
    return this;
  }

  @Override
  public Price set(String fieldName, Object value) {
    return (Price) super.set(fieldName, value);
  }

  @Override
  public Price clone() {
    return (Price) super.clone();
  }

}
