/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A mobile application that contains a external app ID, name, and app store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublisherProfileMobileApplication extends com.google.api.client.json.GenericJson {

  /**
   * The app store the app belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appStore;

  /**
   * The external ID for the app from its app store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalAppId;

  /**
   * The name of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The app store the app belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppStore() {
    return appStore;
  }

  /**
   * The app store the app belongs to.
   * @param appStore appStore or {@code null} for none
   */
  public PublisherProfileMobileApplication setAppStore(java.lang.String appStore) {
    this.appStore = appStore;
    return this;
  }

  /**
   * The external ID for the app from its app store.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalAppId() {
    return externalAppId;
  }

  /**
   * The external ID for the app from its app store.
   * @param externalAppId externalAppId or {@code null} for none
   */
  public PublisherProfileMobileApplication setExternalAppId(java.lang.String externalAppId) {
    this.externalAppId = externalAppId;
    return this;
  }

  /**
   * The name of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the app.
   * @param name name or {@code null} for none
   */
  public PublisherProfileMobileApplication setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public PublisherProfileMobileApplication set(String fieldName, Object value) {
    return (PublisherProfileMobileApplication) super.set(fieldName, value);
  }

  @Override
  public PublisherProfileMobileApplication clone() {
    return (PublisherProfileMobileApplication) super.clone();
  }

}
