/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A relative date range, specified by an offset and a duration. The supported range of dates begins
 * 30 days before today and ends today, i.e., the limits for these values are: offset_days >= 0
 * duration_days >= 1 offset_days + duration_days <= 30
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RelativeDateRange extends com.google.api.client.json.GenericJson {

  /**
   * The number of days in the requested date range, e.g., for a range spanning today: 1. For a
   * range spanning the last 7 days: 7.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer durationDays;

  /**
   * The end date of the filter set, specified as the number of days before today, e.g., for a range
   * where the last date is today: 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer offsetDays;

  /**
   * The number of days in the requested date range, e.g., for a range spanning today: 1. For a
   * range spanning the last 7 days: 7.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDurationDays() {
    return durationDays;
  }

  /**
   * The number of days in the requested date range, e.g., for a range spanning today: 1. For a
   * range spanning the last 7 days: 7.
   * @param durationDays durationDays or {@code null} for none
   */
  public RelativeDateRange setDurationDays(java.lang.Integer durationDays) {
    this.durationDays = durationDays;
    return this;
  }

  /**
   * The end date of the filter set, specified as the number of days before today, e.g., for a range
   * where the last date is today: 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOffsetDays() {
    return offsetDays;
  }

  /**
   * The end date of the filter set, specified as the number of days before today, e.g., for a range
   * where the last date is today: 0.
   * @param offsetDays offsetDays or {@code null} for none
   */
  public RelativeDateRange setOffsetDays(java.lang.Integer offsetDays) {
    this.offsetDays = offsetDays;
    return this;
  }

  @Override
  public RelativeDateRange set(String fieldName, Object value) {
    return (RelativeDateRange) super.set(fieldName, value);
  }

  @Override
  public RelativeDateRange clone() {
    return (RelativeDateRange) super.clone();
  }

}
