/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A response may include multiple rows, breaking down along various dimensions. Encapsulates the
 * values of all dimensions for a given row.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RowDimensions extends com.google.api.client.json.GenericJson {

  /**
   * The publisher identifier for this row, if a breakdown by
   * [BreakdownDimension.PUBLISHER_IDENTIFIER](https://developers.google.com/authorized-
   * buyers/apis/reference/rest/v2beta1/bidders.accounts.filterSets#FilterSet.BreakdownDimension)
   * was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publisherIdentifier;

  /**
   * The time interval that this row represents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInterval timeInterval;

  /**
   * The publisher identifier for this row, if a breakdown by
   * [BreakdownDimension.PUBLISHER_IDENTIFIER](https://developers.google.com/authorized-
   * buyers/apis/reference/rest/v2beta1/bidders.accounts.filterSets#FilterSet.BreakdownDimension)
   * was requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublisherIdentifier() {
    return publisherIdentifier;
  }

  /**
   * The publisher identifier for this row, if a breakdown by
   * [BreakdownDimension.PUBLISHER_IDENTIFIER](https://developers.google.com/authorized-
   * buyers/apis/reference/rest/v2beta1/bidders.accounts.filterSets#FilterSet.BreakdownDimension)
   * was requested.
   * @param publisherIdentifier publisherIdentifier or {@code null} for none
   */
  public RowDimensions setPublisherIdentifier(java.lang.String publisherIdentifier) {
    this.publisherIdentifier = publisherIdentifier;
    return this;
  }

  /**
   * The time interval that this row represents.
   * @return value or {@code null} for none
   */
  public TimeInterval getTimeInterval() {
    return timeInterval;
  }

  /**
   * The time interval that this row represents.
   * @param timeInterval timeInterval or {@code null} for none
   */
  public RowDimensions setTimeInterval(TimeInterval timeInterval) {
    this.timeInterval = timeInterval;
    return this;
  }

  @Override
  public RowDimensions set(String fieldName, Object value) {
    return (RowDimensions) super.set(fieldName, value);
  }

  @Override
  public RowDimensions clone() {
    return (RowDimensions) super.clone();
  }

}
