/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * The serving context for this restriction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServingContext extends com.google.api.client.json.GenericJson {

  /**
   * Matches all contexts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String all;

  /**
   * Matches impressions for a particular app type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppContext appType;

  /**
   * Matches impressions for a particular auction type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AuctionContext auctionType;

  /**
   * Matches impressions coming from users *or* publishers in a specific location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationContext location;

  /**
   * Matches impressions coming from a particular platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlatformContext platform;

  /**
   * Matches impressions for a particular security type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityContext securityType;

  /**
   * Matches all contexts.
   * @return value or {@code null} for none
   */
  public java.lang.String getAll() {
    return all;
  }

  /**
   * Matches all contexts.
   * @param all all or {@code null} for none
   */
  public ServingContext setAll(java.lang.String all) {
    this.all = all;
    return this;
  }

  /**
   * Matches impressions for a particular app type.
   * @return value or {@code null} for none
   */
  public AppContext getAppType() {
    return appType;
  }

  /**
   * Matches impressions for a particular app type.
   * @param appType appType or {@code null} for none
   */
  public ServingContext setAppType(AppContext appType) {
    this.appType = appType;
    return this;
  }

  /**
   * Matches impressions for a particular auction type.
   * @return value or {@code null} for none
   */
  public AuctionContext getAuctionType() {
    return auctionType;
  }

  /**
   * Matches impressions for a particular auction type.
   * @param auctionType auctionType or {@code null} for none
   */
  public ServingContext setAuctionType(AuctionContext auctionType) {
    this.auctionType = auctionType;
    return this;
  }

  /**
   * Matches impressions coming from users *or* publishers in a specific location.
   * @return value or {@code null} for none
   */
  public LocationContext getLocation() {
    return location;
  }

  /**
   * Matches impressions coming from users *or* publishers in a specific location.
   * @param location location or {@code null} for none
   */
  public ServingContext setLocation(LocationContext location) {
    this.location = location;
    return this;
  }

  /**
   * Matches impressions coming from a particular platform.
   * @return value or {@code null} for none
   */
  public PlatformContext getPlatform() {
    return platform;
  }

  /**
   * Matches impressions coming from a particular platform.
   * @param platform platform or {@code null} for none
   */
  public ServingContext setPlatform(PlatformContext platform) {
    this.platform = platform;
    return this;
  }

  /**
   * Matches impressions for a particular security type.
   * @return value or {@code null} for none
   */
  public SecurityContext getSecurityType() {
    return securityType;
  }

  /**
   * Matches impressions for a particular security type.
   * @param securityType securityType or {@code null} for none
   */
  public ServingContext setSecurityType(SecurityContext securityType) {
    this.securityType = securityType;
    return this;
  }

  @Override
  public ServingContext set(String fieldName, Object value) {
    return (ServingContext) super.set(fieldName, value);
  }

  @Override
  public ServingContext clone() {
    return (ServingContext) super.clone();
  }

}
