/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Output only. A representation of the status of an ad in a specific context. A context here
 * relates to where something ultimately serves (for example, a user or publisher geo, a platform,
 * an HTTPS vs HTTP request, or the type of auction).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServingRestriction extends com.google.api.client.json.GenericJson {

  /**
   * The contexts for the restriction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServingContext> contexts;

  static {
    // hack to force ProGuard to consider ServingContext used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ServingContext.class);
  }

  /**
   * Disapproval bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Disapproval disapproval;

  /**
   * Any disapprovals bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method. Deprecated; please use disapproval field
   * instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Disapproval> disapprovalReasons;

  static {
    // hack to force ProGuard to consider Disapproval used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Disapproval.class);
  }

  /**
   * The status of the creative in this context (for example, it has been explicitly disapproved or
   * is pending review).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The contexts for the restriction.
   * @return value or {@code null} for none
   */
  public java.util.List<ServingContext> getContexts() {
    return contexts;
  }

  /**
   * The contexts for the restriction.
   * @param contexts contexts or {@code null} for none
   */
  public ServingRestriction setContexts(java.util.List<ServingContext> contexts) {
    this.contexts = contexts;
    return this;
  }

  /**
   * Disapproval bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method.
   * @return value or {@code null} for none
   */
  public Disapproval getDisapproval() {
    return disapproval;
  }

  /**
   * Disapproval bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method.
   * @param disapproval disapproval or {@code null} for none
   */
  public ServingRestriction setDisapproval(Disapproval disapproval) {
    this.disapproval = disapproval;
    return this;
  }

  /**
   * Any disapprovals bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method. Deprecated; please use disapproval field
   * instead.
   * @return value or {@code null} for none
   */
  public java.util.List<Disapproval> getDisapprovalReasons() {
    return disapprovalReasons;
  }

  /**
   * Any disapprovals bound to this restriction. Only present if status=DISAPPROVED. Can be used to
   * filter the response of the creatives.list method. Deprecated; please use disapproval field
   * instead.
   * @param disapprovalReasons disapprovalReasons or {@code null} for none
   */
  public ServingRestriction setDisapprovalReasons(java.util.List<Disapproval> disapprovalReasons) {
    this.disapprovalReasons = disapprovalReasons;
    return this;
  }

  /**
   * The status of the creative in this context (for example, it has been explicitly disapproved or
   * is pending review).
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the creative in this context (for example, it has been explicitly disapproved or
   * is pending review).
   * @param status status or {@code null} for none
   */
  public ServingRestriction setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public ServingRestriction set(String fieldName, Object value) {
    return (ServingRestriction) super.set(fieldName, value);
  }

  @Override
  public ServingRestriction clone() {
    return (ServingRestriction) super.clone();
  }

}
