/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Advertisers can target different attributes of an ad slot. For example, they can choose to show
 * ads only if the user is in the U.S. Such targeting criteria can be specified as part of Shared
 * Targeting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetingCriteria extends com.google.api.client.json.GenericJson {

  /**
   * The list of values to exclude from targeting. Each value is AND'd together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TargetingValue> exclusions;

  /**
   * The list of value to include as part of the targeting. Each value is OR'd together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TargetingValue> inclusions;

  /**
   * The key representing the shared targeting criterion. Targeting criteria defined by Google ad
   * servers will begin with GOOG_. Third parties may define their own keys. A list of permissible
   * keys along with the acceptable values will be provided as part of the external documentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The list of values to exclude from targeting. Each value is AND'd together.
   * @return value or {@code null} for none
   */
  public java.util.List<TargetingValue> getExclusions() {
    return exclusions;
  }

  /**
   * The list of values to exclude from targeting. Each value is AND'd together.
   * @param exclusions exclusions or {@code null} for none
   */
  public TargetingCriteria setExclusions(java.util.List<TargetingValue> exclusions) {
    this.exclusions = exclusions;
    return this;
  }

  /**
   * The list of value to include as part of the targeting. Each value is OR'd together.
   * @return value or {@code null} for none
   */
  public java.util.List<TargetingValue> getInclusions() {
    return inclusions;
  }

  /**
   * The list of value to include as part of the targeting. Each value is OR'd together.
   * @param inclusions inclusions or {@code null} for none
   */
  public TargetingCriteria setInclusions(java.util.List<TargetingValue> inclusions) {
    this.inclusions = inclusions;
    return this;
  }

  /**
   * The key representing the shared targeting criterion. Targeting criteria defined by Google ad
   * servers will begin with GOOG_. Third parties may define their own keys. A list of permissible
   * keys along with the acceptable values will be provided as part of the external documentation.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * The key representing the shared targeting criterion. Targeting criteria defined by Google ad
   * servers will begin with GOOG_. Third parties may define their own keys. A list of permissible
   * keys along with the acceptable values will be provided as part of the external documentation.
   * @param key key or {@code null} for none
   */
  public TargetingCriteria setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  @Override
  public TargetingCriteria set(String fieldName, Object value) {
    return (TargetingCriteria) super.set(fieldName, value);
  }

  @Override
  public TargetingCriteria clone() {
    return (TargetingCriteria) super.clone();
  }

}
