/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * Represents targeting about various types of technology.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TechnologyTargeting extends com.google.api.client.json.GenericJson {

  /**
   * IDs of device capabilities to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CriteriaTargeting deviceCapabilityTargeting;

  /**
   * IDs of device categories to be included/excluded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CriteriaTargeting deviceCategoryTargeting;

  /**
   * Operating system related targeting information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OperatingSystemTargeting operatingSystemTargeting;

  /**
   * IDs of device capabilities to be included/excluded.
   * @return value or {@code null} for none
   */
  public CriteriaTargeting getDeviceCapabilityTargeting() {
    return deviceCapabilityTargeting;
  }

  /**
   * IDs of device capabilities to be included/excluded.
   * @param deviceCapabilityTargeting deviceCapabilityTargeting or {@code null} for none
   */
  public TechnologyTargeting setDeviceCapabilityTargeting(CriteriaTargeting deviceCapabilityTargeting) {
    this.deviceCapabilityTargeting = deviceCapabilityTargeting;
    return this;
  }

  /**
   * IDs of device categories to be included/excluded.
   * @return value or {@code null} for none
   */
  public CriteriaTargeting getDeviceCategoryTargeting() {
    return deviceCategoryTargeting;
  }

  /**
   * IDs of device categories to be included/excluded.
   * @param deviceCategoryTargeting deviceCategoryTargeting or {@code null} for none
   */
  public TechnologyTargeting setDeviceCategoryTargeting(CriteriaTargeting deviceCategoryTargeting) {
    this.deviceCategoryTargeting = deviceCategoryTargeting;
    return this;
  }

  /**
   * Operating system related targeting information.
   * @return value or {@code null} for none
   */
  public OperatingSystemTargeting getOperatingSystemTargeting() {
    return operatingSystemTargeting;
  }

  /**
   * Operating system related targeting information.
   * @param operatingSystemTargeting operatingSystemTargeting or {@code null} for none
   */
  public TechnologyTargeting setOperatingSystemTargeting(OperatingSystemTargeting operatingSystemTargeting) {
    this.operatingSystemTargeting = operatingSystemTargeting;
    return this;
  }

  @Override
  public TechnologyTargeting set(String fieldName, Object value) {
    return (TechnologyTargeting) super.set(fieldName, value);
  }

  @Override
  public TechnologyTargeting clone() {
    return (TechnologyTargeting) super.clone();
  }

}
