/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.adexchangebuyer2.v2beta1.model;

/**
 * A request for watching changes to creative Status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Ad Exchange Buyer API II. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WatchCreativeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The Pub/Sub topic to publish notifications to. This topic must already exist and must give
   * permission to ad-exchange-buyside-reports@google.com to write to the topic. This should be the
   * full resource name in "projects/{project_id}/topics/{topic_id}" format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * The Pub/Sub topic to publish notifications to. This topic must already exist and must give
   * permission to ad-exchange-buyside-reports@google.com to write to the topic. This should be the
   * full resource name in "projects/{project_id}/topics/{topic_id}" format.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * The Pub/Sub topic to publish notifications to. This topic must already exist and must give
   * permission to ad-exchange-buyside-reports@google.com to write to the topic. This should be the
   * full resource name in "projects/{project_id}/topics/{topic_id}" format.
   * @param topic topic or {@code null} for none
   */
  public WatchCreativeRequest setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public WatchCreativeRequest set(String fieldName, Object value) {
    return (WatchCreativeRequest) super.set(fieldName, value);
  }

  @Override
  public WatchCreativeRequest clone() {
    return (WatchCreativeRequest) super.clone();
  }

}
