/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.adexchangebuyer2.v2beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.adexchangebuyer2.v2beta1.AdExchangeBuyerIIRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.AdExchangeBuyerIIRequestInitializer;
import com.google.api.services.adexchangebuyer2.v2beta1.model.AcceptProposalRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.AddDealAssociationRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.AddNoteRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.CancelNegotiationRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Client;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ClientUser;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ClientUserInvitation;
import com.google.api.services.adexchangebuyer2.v2beta1.model.CompleteSetupRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Creative;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Empty;
import com.google.api.services.adexchangebuyer2.v2beta1.model.FilterSet;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListBidMetricsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListBidResponseErrorsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListBidResponsesWithoutBidsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListClientUserInvitationsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListClientUsersResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListClientsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListCreativeStatusBreakdownByCreativeResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListCreativeStatusBreakdownByDetailResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListCreativesResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListDealAssociationsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListFilterSetsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListFilteredBidRequestsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListFilteredBidsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListImpressionMetricsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListLosingBidsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListNonBillableWinningBidsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListProductsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListProposalsResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ListPublisherProfilesResponse;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Note;
import com.google.api.services.adexchangebuyer2.v2beta1.model.PauseProposalDealsRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.PauseProposalRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Product;
import com.google.api.services.adexchangebuyer2.v2beta1.model.Proposal;
import com.google.api.services.adexchangebuyer2.v2beta1.model.PublisherProfile;
import com.google.api.services.adexchangebuyer2.v2beta1.model.RemoveDealAssociationRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ResumeProposalDealsRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.ResumeProposalRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.StopWatchingCreativeRequest;
import com.google.api.services.adexchangebuyer2.v2beta1.model.WatchCreativeRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class AdExchangeBuyerII
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://adexchangebuyer.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://adexchangebuyer.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://adexchangebuyer.googleapis.com/";

    public AdExchangeBuyerII(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AdExchangeBuyerII(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    public Bidders bidders() {
        return new Bidders();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Ad Exchange Buyer API II library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AdExchangeBuyerII.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://adexchangebuyer.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AdExchangeBuyerII.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AdExchangeBuyerII.DEFAULT_BATCH_PATH);
        }

        public AdExchangeBuyerII build() {
            return new AdExchangeBuyerII(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAdExchangeBuyerIIRequestInitializer(AdExchangeBuyerIIRequestInitializer adexchangebuyeriiRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)adexchangebuyeriiRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Bidders {
        public Accounts accounts() {
            return new Accounts();
        }

        public FilterSets filterSets() {
            return new FilterSets();
        }

        public class FilterSets {
            public Create create(String ownerName, FilterSet content) throws IOException {
                Create result = new Create(ownerName, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String ownerName) throws IOException {
                List result = new List(ownerName);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BidMetrics bidMetrics() {
                return new BidMetrics();
            }

            public BidResponseErrors bidResponseErrors() {
                return new BidResponseErrors();
            }

            public BidResponsesWithoutBids bidResponsesWithoutBids() {
                return new BidResponsesWithoutBids();
            }

            public FilteredBidRequests filteredBidRequests() {
                return new FilteredBidRequests();
            }

            public FilteredBids filteredBids() {
                return new FilteredBids();
            }

            public ImpressionMetrics impressionMetrics() {
                return new ImpressionMetrics();
            }

            public LosingBids losingBids() {
                return new LosingBids();
            }

            public NonBillableWinningBids nonBillableWinningBids() {
                return new NonBillableWinningBids();
            }

            public class NonBillableWinningBids {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListNonBillableWinningBidsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/nonBillableWinningBids";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListNonBillableWinningBidsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class LosingBids {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListLosingBidsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/losingBids";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListLosingBidsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class ImpressionMetrics {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListImpressionMetricsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/impressionMetrics";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListImpressionMetricsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class FilteredBids {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Creatives creatives() {
                    return new Creatives();
                }

                public Details details() {
                    return new Details();
                }

                public class Details {
                    public List list(String filterSetName, Integer creativeStatusId) throws IOException {
                        List result = new List(filterSetName, creativeStatusId);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListCreativeStatusBreakdownByDetailResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids/{creativeStatusId}/details";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer creativeStatusId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName, Integer creativeStatusId) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListCreativeStatusBreakdownByDetailResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                            }
                            this.creativeStatusId = (Integer)Preconditions.checkNotNull((Object)creativeStatusId, (Object)"Required parameter creativeStatusId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getCreativeStatusId() {
                            return this.creativeStatusId;
                        }

                        public List setCreativeStatusId(Integer creativeStatusId) {
                            this.creativeStatusId = creativeStatusId;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class Creatives {
                    public List list(String filterSetName, Integer creativeStatusId) throws IOException {
                        List result = new List(filterSetName, creativeStatusId);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListCreativeStatusBreakdownByCreativeResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids/{creativeStatusId}/creatives";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer creativeStatusId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName, Integer creativeStatusId) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListCreativeStatusBreakdownByCreativeResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                            }
                            this.creativeStatusId = (Integer)Preconditions.checkNotNull((Object)creativeStatusId, (Object)"Required parameter creativeStatusId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getCreativeStatusId() {
                            return this.creativeStatusId;
                        }

                        public List setCreativeStatusId(Integer creativeStatusId) {
                            this.creativeStatusId = creativeStatusId;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListFilteredBidsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilteredBidsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class FilteredBidRequests {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListFilteredBidRequestsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBidRequests";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilteredBidRequestsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class BidResponsesWithoutBids {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListBidResponsesWithoutBidsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/bidResponsesWithoutBids";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidResponsesWithoutBidsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class BidResponseErrors {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListBidResponseErrorsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/bidResponseErrors";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidResponseErrorsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class BidMetrics {
                public List list(String filterSetName) throws IOException {
                    List result = new List(filterSetName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListBidMetricsResponse> {
                    private static final String REST_PATH = "v2beta1/{+filterSetName}/bidMetrics";
                    private final Pattern FILTER_SET_NAME_PATTERN;
                    @Key
                    private String filterSetName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String filterSetName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidMetricsResponse.class);
                        this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                        this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getFilterSetName() {
                        return this.filterSetName;
                    }

                    public List setFilterSetName(String filterSetName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                        }
                        this.filterSetName = filterSetName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListFilterSetsResponse> {
                private static final String REST_PATH = "v2beta1/{+ownerName}/filterSets";
                private final Pattern OWNER_NAME_PATTERN;
                @Key
                private String ownerName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String ownerName) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilterSetsResponse.class);
                    this.OWNER_NAME_PATTERN = Pattern.compile("^bidders/[^/]+$");
                    this.ownerName = (String)Preconditions.checkNotNull((Object)ownerName, (Object)"Required parameter ownerName must be specified.");
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getOwnerName() {
                    return this.ownerName;
                }

                public List setOwnerName(String ownerName) {
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+$");
                    }
                    this.ownerName = ownerName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<FilterSet> {
                private static final String REST_PATH = "v2beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, FilterSet.class);
                    this.NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AdExchangeBuyerIIRequest<Empty> {
                private static final String REST_PATH = "v2beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(AdExchangeBuyerII.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^bidders/[^/]+/filterSets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/filterSets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdExchangeBuyerIIRequest<FilterSet> {
                private static final String REST_PATH = "v2beta1/{+ownerName}/filterSets";
                private final Pattern OWNER_NAME_PATTERN;
                @Key
                private String ownerName;
                @Key
                private Boolean isTransient;

                protected Create(String ownerName, FilterSet content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, FilterSet.class);
                    this.OWNER_NAME_PATTERN = Pattern.compile("^bidders/[^/]+$");
                    this.ownerName = (String)Preconditions.checkNotNull((Object)ownerName, (Object)"Required parameter ownerName must be specified.");
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getOwnerName() {
                    return this.ownerName;
                }

                public Create setOwnerName(String ownerName) {
                    if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+$");
                    }
                    this.ownerName = ownerName;
                    return this;
                }

                public Boolean getIsTransient() {
                    return this.isTransient;
                }

                public Create setIsTransient(Boolean isTransient) {
                    this.isTransient = isTransient;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Accounts {
            public FilterSets filterSets() {
                return new FilterSets();
            }

            public class FilterSets {
                public Create create(String ownerName, FilterSet content) throws IOException {
                    Create result = new Create(ownerName, content);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String ownerName) throws IOException {
                    List result = new List(ownerName);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public BidMetrics bidMetrics() {
                    return new BidMetrics();
                }

                public BidResponseErrors bidResponseErrors() {
                    return new BidResponseErrors();
                }

                public BidResponsesWithoutBids bidResponsesWithoutBids() {
                    return new BidResponsesWithoutBids();
                }

                public FilteredBidRequests filteredBidRequests() {
                    return new FilteredBidRequests();
                }

                public FilteredBids filteredBids() {
                    return new FilteredBids();
                }

                public ImpressionMetrics impressionMetrics() {
                    return new ImpressionMetrics();
                }

                public LosingBids losingBids() {
                    return new LosingBids();
                }

                public NonBillableWinningBids nonBillableWinningBids() {
                    return new NonBillableWinningBids();
                }

                public class NonBillableWinningBids {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListNonBillableWinningBidsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/nonBillableWinningBids";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListNonBillableWinningBidsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class LosingBids {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListLosingBidsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/losingBids";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListLosingBidsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class ImpressionMetrics {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListImpressionMetricsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/impressionMetrics";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListImpressionMetricsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class FilteredBids {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Creatives creatives() {
                        return new Creatives();
                    }

                    public Details details() {
                        return new Details();
                    }

                    public class Details {
                        public List list(String filterSetName, Integer creativeStatusId) throws IOException {
                            List result = new List(filterSetName, creativeStatusId);
                            AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends AdExchangeBuyerIIRequest<ListCreativeStatusBreakdownByDetailResponse> {
                            private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids/{creativeStatusId}/details";
                            private final Pattern FILTER_SET_NAME_PATTERN;
                            @Key
                            private String filterSetName;
                            @Key
                            private Integer creativeStatusId;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String filterSetName, Integer creativeStatusId) {
                                super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListCreativeStatusBreakdownByDetailResponse.class);
                                this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                                if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                }
                                this.creativeStatusId = (Integer)Preconditions.checkNotNull((Object)creativeStatusId, (Object)"Required parameter creativeStatusId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getFilterSetName() {
                                return this.filterSetName;
                            }

                            public List setFilterSetName(String filterSetName) {
                                if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                }
                                this.filterSetName = filterSetName;
                                return this;
                            }

                            public Integer getCreativeStatusId() {
                                return this.creativeStatusId;
                            }

                            public List setCreativeStatusId(Integer creativeStatusId) {
                                this.creativeStatusId = creativeStatusId;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class Creatives {
                        public List list(String filterSetName, Integer creativeStatusId) throws IOException {
                            List result = new List(filterSetName, creativeStatusId);
                            AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends AdExchangeBuyerIIRequest<ListCreativeStatusBreakdownByCreativeResponse> {
                            private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids/{creativeStatusId}/creatives";
                            private final Pattern FILTER_SET_NAME_PATTERN;
                            @Key
                            private String filterSetName;
                            @Key
                            private Integer creativeStatusId;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String filterSetName, Integer creativeStatusId) {
                                super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListCreativeStatusBreakdownByCreativeResponse.class);
                                this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                                if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                }
                                this.creativeStatusId = (Integer)Preconditions.checkNotNull((Object)creativeStatusId, (Object)"Required parameter creativeStatusId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getFilterSetName() {
                                return this.filterSetName;
                            }

                            public List setFilterSetName(String filterSetName) {
                                if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                                }
                                this.filterSetName = filterSetName;
                                return this;
                            }

                            public Integer getCreativeStatusId() {
                                return this.creativeStatusId;
                            }

                            public List setCreativeStatusId(Integer creativeStatusId) {
                                this.creativeStatusId = creativeStatusId;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListFilteredBidsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBids";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilteredBidsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class FilteredBidRequests {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListFilteredBidRequestsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/filteredBidRequests";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilteredBidRequestsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class BidResponsesWithoutBids {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListBidResponsesWithoutBidsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/bidResponsesWithoutBids";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidResponsesWithoutBidsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class BidResponseErrors {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListBidResponseErrorsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/bidResponseErrors";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidResponseErrorsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class BidMetrics {
                    public List list(String filterSetName) throws IOException {
                        List result = new List(filterSetName);
                        AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends AdExchangeBuyerIIRequest<ListBidMetricsResponse> {
                        private static final String REST_PATH = "v2beta1/{+filterSetName}/bidMetrics";
                        private final Pattern FILTER_SET_NAME_PATTERN;
                        @Key
                        private String filterSetName;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String filterSetName) {
                            super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListBidMetricsResponse.class);
                            this.FILTER_SET_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            this.filterSetName = (String)Preconditions.checkNotNull((Object)filterSetName, (Object)"Required parameter filterSetName must be specified.");
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getFilterSetName() {
                            return this.filterSetName;
                        }

                        public List setFilterSetName(String filterSetName) {
                            if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.FILTER_SET_NAME_PATTERN.matcher(filterSetName).matches(), (Object)"Parameter filterSetName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                            }
                            this.filterSetName = filterSetName;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListFilterSetsResponse> {
                    private static final String REST_PATH = "v2beta1/{+ownerName}/filterSets";
                    private final Pattern OWNER_NAME_PATTERN;
                    @Key
                    private String ownerName;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String ownerName) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListFilterSetsResponse.class);
                        this.OWNER_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+$");
                        this.ownerName = (String)Preconditions.checkNotNull((Object)ownerName, (Object)"Required parameter ownerName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getOwnerName() {
                        return this.ownerName;
                    }

                    public List setOwnerName(String ownerName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+$");
                        }
                        this.ownerName = ownerName;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends AdExchangeBuyerIIRequest<FilterSet> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, FilterSet.class);
                        this.NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends AdExchangeBuyerIIRequest<Empty> {
                    private static final String REST_PATH = "v2beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(AdExchangeBuyerII.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^bidders/[^/]+/accounts/[^/]+/filterSets/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends AdExchangeBuyerIIRequest<FilterSet> {
                    private static final String REST_PATH = "v2beta1/{+ownerName}/filterSets";
                    private final Pattern OWNER_NAME_PATTERN;
                    @Key
                    private String ownerName;
                    @Key
                    private Boolean isTransient;

                    protected Create(String ownerName, FilterSet content) {
                        super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, FilterSet.class);
                        this.OWNER_NAME_PATTERN = Pattern.compile("^bidders/[^/]+/accounts/[^/]+$");
                        this.ownerName = (String)Preconditions.checkNotNull((Object)ownerName, (Object)"Required parameter ownerName must be specified.");
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getOwnerName() {
                        return this.ownerName;
                    }

                    public Create setOwnerName(String ownerName) {
                        if (!AdExchangeBuyerII.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.OWNER_NAME_PATTERN.matcher(ownerName).matches(), (Object)"Parameter ownerName must conform to the pattern ^bidders/[^/]+/accounts/[^/]+$");
                        }
                        this.ownerName = ownerName;
                        return this;
                    }

                    public Boolean getIsTransient() {
                        return this.isTransient;
                    }

                    public Create setIsTransient(Boolean isTransient) {
                        this.isTransient = isTransient;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }
        }
    }

    public class Accounts {
        public Clients clients() {
            return new Clients();
        }

        public Creatives creatives() {
            return new Creatives();
        }

        public FinalizedProposals finalizedProposals() {
            return new FinalizedProposals();
        }

        public Products products() {
            return new Products();
        }

        public Proposals proposals() {
            return new Proposals();
        }

        public PublisherProfiles publisherProfiles() {
            return new PublisherProfiles();
        }

        public class PublisherProfiles {
            public Get get(String accountId, String publisherProfileId) throws IOException {
                Get result = new Get(accountId, publisherProfileId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListPublisherProfilesResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/publisherProfiles";
                @Key
                private String accountId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListPublisherProfilesResponse.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<PublisherProfile> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/publisherProfiles/{publisherProfileId}";
                @Key
                private String accountId;
                @Key
                private String publisherProfileId;

                protected Get(String accountId, String publisherProfileId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, PublisherProfile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.publisherProfileId = (String)Preconditions.checkNotNull((Object)publisherProfileId, (Object)"Required parameter publisherProfileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getPublisherProfileId() {
                    return this.publisherProfileId;
                }

                public Get setPublisherProfileId(String publisherProfileId) {
                    this.publisherProfileId = publisherProfileId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Proposals {
            public Accept accept(String accountId, String proposalId, AcceptProposalRequest content) throws IOException {
                Accept result = new Accept(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AddNote addNote(String accountId, String proposalId, AddNoteRequest content) throws IOException {
                AddNote result = new AddNote(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public CancelNegotiation cancelNegotiation(String accountId, String proposalId, CancelNegotiationRequest content) throws IOException {
                CancelNegotiation result = new CancelNegotiation(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public CompleteSetup completeSetup(String accountId, String proposalId, CompleteSetupRequest content) throws IOException {
                CompleteSetup result = new CompleteSetup(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String accountId, Proposal content) throws IOException {
                Create result = new Create(accountId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String proposalId) throws IOException {
                Get result = new Get(accountId, proposalId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Pause pause(String accountId, String proposalId, PauseProposalRequest content) throws IOException {
                Pause result = new Pause(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Resume resume(String accountId, String proposalId, ResumeProposalRequest content) throws IOException {
                Resume result = new Resume(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String proposalId, Proposal content) throws IOException {
                Update result = new Update(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Update(String accountId, String proposalId, Proposal content) {
                    super(AdExchangeBuyerII.this, "PUT", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Update setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Resume
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:resume";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Resume(String accountId, String proposalId, ResumeProposalRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Resume set$Xgafv(String $Xgafv) {
                    return (Resume)super.set$Xgafv($Xgafv);
                }

                public Resume setAccessToken(String accessToken) {
                    return (Resume)super.setAccessToken(accessToken);
                }

                public Resume setAlt(String alt) {
                    return (Resume)super.setAlt(alt);
                }

                public Resume setCallback(String callback) {
                    return (Resume)super.setCallback(callback);
                }

                public Resume setFields(String fields) {
                    return (Resume)super.setFields(fields);
                }

                public Resume setKey(String key) {
                    return (Resume)super.setKey(key);
                }

                public Resume setOauthToken(String oauthToken) {
                    return (Resume)super.setOauthToken(oauthToken);
                }

                public Resume setPrettyPrint(Boolean prettyPrint) {
                    return (Resume)super.setPrettyPrint(prettyPrint);
                }

                public Resume setQuotaUser(String quotaUser) {
                    return (Resume)super.setQuotaUser(quotaUser);
                }

                public Resume setUploadType(String uploadType) {
                    return (Resume)super.setUploadType(uploadType);
                }

                public Resume setUploadProtocol(String uploadProtocol) {
                    return (Resume)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Resume setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Resume setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Resume set(String parameterName, Object value) {
                    return (Resume)super.set(parameterName, value);
                }
            }

            public class Pause
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:pause";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Pause(String accountId, String proposalId, PauseProposalRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Pause set$Xgafv(String $Xgafv) {
                    return (Pause)super.set$Xgafv($Xgafv);
                }

                public Pause setAccessToken(String accessToken) {
                    return (Pause)super.setAccessToken(accessToken);
                }

                public Pause setAlt(String alt) {
                    return (Pause)super.setAlt(alt);
                }

                public Pause setCallback(String callback) {
                    return (Pause)super.setCallback(callback);
                }

                public Pause setFields(String fields) {
                    return (Pause)super.setFields(fields);
                }

                public Pause setKey(String key) {
                    return (Pause)super.setKey(key);
                }

                public Pause setOauthToken(String oauthToken) {
                    return (Pause)super.setOauthToken(oauthToken);
                }

                public Pause setPrettyPrint(Boolean prettyPrint) {
                    return (Pause)super.setPrettyPrint(prettyPrint);
                }

                public Pause setQuotaUser(String quotaUser) {
                    return (Pause)super.setQuotaUser(quotaUser);
                }

                public Pause setUploadType(String uploadType) {
                    return (Pause)super.setUploadType(uploadType);
                }

                public Pause setUploadProtocol(String uploadProtocol) {
                    return (Pause)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Pause setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Pause setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Pause set(String parameterName, Object value) {
                    return (Pause)super.set(parameterName, value);
                }
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListProposalsResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals";
                @Key
                private String accountId;
                @Key
                private String filter;
                @Key
                private String filterSyntax;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListProposalsResponse.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getFilterSyntax() {
                    return this.filterSyntax;
                }

                public List setFilterSyntax(String filterSyntax) {
                    this.filterSyntax = filterSyntax;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Get(String accountId, String proposalId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Get setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals";
                @Key
                private String accountId;

                protected Create(String accountId, Proposal content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class CompleteSetup
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:completeSetup";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected CompleteSetup(String accountId, String proposalId, CompleteSetupRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public CompleteSetup set$Xgafv(String $Xgafv) {
                    return (CompleteSetup)super.set$Xgafv($Xgafv);
                }

                public CompleteSetup setAccessToken(String accessToken) {
                    return (CompleteSetup)super.setAccessToken(accessToken);
                }

                public CompleteSetup setAlt(String alt) {
                    return (CompleteSetup)super.setAlt(alt);
                }

                public CompleteSetup setCallback(String callback) {
                    return (CompleteSetup)super.setCallback(callback);
                }

                public CompleteSetup setFields(String fields) {
                    return (CompleteSetup)super.setFields(fields);
                }

                public CompleteSetup setKey(String key) {
                    return (CompleteSetup)super.setKey(key);
                }

                public CompleteSetup setOauthToken(String oauthToken) {
                    return (CompleteSetup)super.setOauthToken(oauthToken);
                }

                public CompleteSetup setPrettyPrint(Boolean prettyPrint) {
                    return (CompleteSetup)super.setPrettyPrint(prettyPrint);
                }

                public CompleteSetup setQuotaUser(String quotaUser) {
                    return (CompleteSetup)super.setQuotaUser(quotaUser);
                }

                public CompleteSetup setUploadType(String uploadType) {
                    return (CompleteSetup)super.setUploadType(uploadType);
                }

                public CompleteSetup setUploadProtocol(String uploadProtocol) {
                    return (CompleteSetup)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public CompleteSetup setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public CompleteSetup setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public CompleteSetup set(String parameterName, Object value) {
                    return (CompleteSetup)super.set(parameterName, value);
                }
            }

            public class CancelNegotiation
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:cancelNegotiation";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected CancelNegotiation(String accountId, String proposalId, CancelNegotiationRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public CancelNegotiation set$Xgafv(String $Xgafv) {
                    return (CancelNegotiation)super.set$Xgafv($Xgafv);
                }

                public CancelNegotiation setAccessToken(String accessToken) {
                    return (CancelNegotiation)super.setAccessToken(accessToken);
                }

                public CancelNegotiation setAlt(String alt) {
                    return (CancelNegotiation)super.setAlt(alt);
                }

                public CancelNegotiation setCallback(String callback) {
                    return (CancelNegotiation)super.setCallback(callback);
                }

                public CancelNegotiation setFields(String fields) {
                    return (CancelNegotiation)super.setFields(fields);
                }

                public CancelNegotiation setKey(String key) {
                    return (CancelNegotiation)super.setKey(key);
                }

                public CancelNegotiation setOauthToken(String oauthToken) {
                    return (CancelNegotiation)super.setOauthToken(oauthToken);
                }

                public CancelNegotiation setPrettyPrint(Boolean prettyPrint) {
                    return (CancelNegotiation)super.setPrettyPrint(prettyPrint);
                }

                public CancelNegotiation setQuotaUser(String quotaUser) {
                    return (CancelNegotiation)super.setQuotaUser(quotaUser);
                }

                public CancelNegotiation setUploadType(String uploadType) {
                    return (CancelNegotiation)super.setUploadType(uploadType);
                }

                public CancelNegotiation setUploadProtocol(String uploadProtocol) {
                    return (CancelNegotiation)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public CancelNegotiation setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public CancelNegotiation setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public CancelNegotiation set(String parameterName, Object value) {
                    return (CancelNegotiation)super.set(parameterName, value);
                }
            }

            public class AddNote
            extends AdExchangeBuyerIIRequest<Note> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:addNote";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected AddNote(String accountId, String proposalId, AddNoteRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Note.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public AddNote set$Xgafv(String $Xgafv) {
                    return (AddNote)super.set$Xgafv($Xgafv);
                }

                public AddNote setAccessToken(String accessToken) {
                    return (AddNote)super.setAccessToken(accessToken);
                }

                public AddNote setAlt(String alt) {
                    return (AddNote)super.setAlt(alt);
                }

                public AddNote setCallback(String callback) {
                    return (AddNote)super.setCallback(callback);
                }

                public AddNote setFields(String fields) {
                    return (AddNote)super.setFields(fields);
                }

                public AddNote setKey(String key) {
                    return (AddNote)super.setKey(key);
                }

                public AddNote setOauthToken(String oauthToken) {
                    return (AddNote)super.setOauthToken(oauthToken);
                }

                public AddNote setPrettyPrint(Boolean prettyPrint) {
                    return (AddNote)super.setPrettyPrint(prettyPrint);
                }

                public AddNote setQuotaUser(String quotaUser) {
                    return (AddNote)super.setQuotaUser(quotaUser);
                }

                public AddNote setUploadType(String uploadType) {
                    return (AddNote)super.setUploadType(uploadType);
                }

                public AddNote setUploadProtocol(String uploadProtocol) {
                    return (AddNote)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public AddNote setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public AddNote setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public AddNote set(String parameterName, Object value) {
                    return (AddNote)super.set(parameterName, value);
                }
            }

            public class Accept
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/proposals/{proposalId}:accept";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Accept(String accountId, String proposalId, AcceptProposalRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Accept set$Xgafv(String $Xgafv) {
                    return (Accept)super.set$Xgafv($Xgafv);
                }

                public Accept setAccessToken(String accessToken) {
                    return (Accept)super.setAccessToken(accessToken);
                }

                public Accept setAlt(String alt) {
                    return (Accept)super.setAlt(alt);
                }

                public Accept setCallback(String callback) {
                    return (Accept)super.setCallback(callback);
                }

                public Accept setFields(String fields) {
                    return (Accept)super.setFields(fields);
                }

                public Accept setKey(String key) {
                    return (Accept)super.setKey(key);
                }

                public Accept setOauthToken(String oauthToken) {
                    return (Accept)super.setOauthToken(oauthToken);
                }

                public Accept setPrettyPrint(Boolean prettyPrint) {
                    return (Accept)super.setPrettyPrint(prettyPrint);
                }

                public Accept setQuotaUser(String quotaUser) {
                    return (Accept)super.setQuotaUser(quotaUser);
                }

                public Accept setUploadType(String uploadType) {
                    return (Accept)super.setUploadType(uploadType);
                }

                public Accept setUploadProtocol(String uploadProtocol) {
                    return (Accept)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Accept setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Accept setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Accept set(String parameterName, Object value) {
                    return (Accept)super.set(parameterName, value);
                }
            }
        }

        public class Products {
            public Get get(String accountId, String productId) throws IOException {
                Get result = new Get(accountId, productId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListProductsResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/products";
                @Key
                private String accountId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListProductsResponse.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<Product> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/products/{productId}";
                @Key
                private String accountId;
                @Key
                private String productId;

                protected Get(String accountId, String productId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, Product.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public Get setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class FinalizedProposals {
            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Pause pause(String accountId, String proposalId, PauseProposalDealsRequest content) throws IOException {
                Pause result = new Pause(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Resume resume(String accountId, String proposalId, ResumeProposalDealsRequest content) throws IOException {
                Resume result = new Resume(accountId, proposalId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Resume
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/finalizedProposals/{proposalId}:resume";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Resume(String accountId, String proposalId, ResumeProposalDealsRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Resume set$Xgafv(String $Xgafv) {
                    return (Resume)super.set$Xgafv($Xgafv);
                }

                public Resume setAccessToken(String accessToken) {
                    return (Resume)super.setAccessToken(accessToken);
                }

                public Resume setAlt(String alt) {
                    return (Resume)super.setAlt(alt);
                }

                public Resume setCallback(String callback) {
                    return (Resume)super.setCallback(callback);
                }

                public Resume setFields(String fields) {
                    return (Resume)super.setFields(fields);
                }

                public Resume setKey(String key) {
                    return (Resume)super.setKey(key);
                }

                public Resume setOauthToken(String oauthToken) {
                    return (Resume)super.setOauthToken(oauthToken);
                }

                public Resume setPrettyPrint(Boolean prettyPrint) {
                    return (Resume)super.setPrettyPrint(prettyPrint);
                }

                public Resume setQuotaUser(String quotaUser) {
                    return (Resume)super.setQuotaUser(quotaUser);
                }

                public Resume setUploadType(String uploadType) {
                    return (Resume)super.setUploadType(uploadType);
                }

                public Resume setUploadProtocol(String uploadProtocol) {
                    return (Resume)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Resume setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Resume setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Resume set(String parameterName, Object value) {
                    return (Resume)super.set(parameterName, value);
                }
            }

            public class Pause
            extends AdExchangeBuyerIIRequest<Proposal> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/finalizedProposals/{proposalId}:pause";
                @Key
                private String accountId;
                @Key
                private String proposalId;

                protected Pause(String accountId, String proposalId, PauseProposalDealsRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Proposal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.proposalId = (String)Preconditions.checkNotNull((Object)proposalId, (Object)"Required parameter proposalId must be specified.");
                }

                public Pause set$Xgafv(String $Xgafv) {
                    return (Pause)super.set$Xgafv($Xgafv);
                }

                public Pause setAccessToken(String accessToken) {
                    return (Pause)super.setAccessToken(accessToken);
                }

                public Pause setAlt(String alt) {
                    return (Pause)super.setAlt(alt);
                }

                public Pause setCallback(String callback) {
                    return (Pause)super.setCallback(callback);
                }

                public Pause setFields(String fields) {
                    return (Pause)super.setFields(fields);
                }

                public Pause setKey(String key) {
                    return (Pause)super.setKey(key);
                }

                public Pause setOauthToken(String oauthToken) {
                    return (Pause)super.setOauthToken(oauthToken);
                }

                public Pause setPrettyPrint(Boolean prettyPrint) {
                    return (Pause)super.setPrettyPrint(prettyPrint);
                }

                public Pause setQuotaUser(String quotaUser) {
                    return (Pause)super.setQuotaUser(quotaUser);
                }

                public Pause setUploadType(String uploadType) {
                    return (Pause)super.setUploadType(uploadType);
                }

                public Pause setUploadProtocol(String uploadProtocol) {
                    return (Pause)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Pause setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getProposalId() {
                    return this.proposalId;
                }

                public Pause setProposalId(String proposalId) {
                    this.proposalId = proposalId;
                    return this;
                }

                @Override
                public Pause set(String parameterName, Object value) {
                    return (Pause)super.set(parameterName, value);
                }
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListProposalsResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/finalizedProposals";
                @Key
                private String accountId;
                @Key
                private String filter;
                @Key
                private String filterSyntax;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListProposalsResponse.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getFilterSyntax() {
                    return this.filterSyntax;
                }

                public List setFilterSyntax(String filterSyntax) {
                    this.filterSyntax = filterSyntax;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Creatives {
            public Create create(String accountId, Creative content) throws IOException {
                Create result = new Create(accountId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String creativeId) throws IOException {
                Get result = new Get(accountId, creativeId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public StopWatching stopWatching(String accountId, String creativeId, StopWatchingCreativeRequest content) throws IOException {
                StopWatching result = new StopWatching(accountId, creativeId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String creativeId, Creative content) throws IOException {
                Update result = new Update(accountId, creativeId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Watch watch(String accountId, String creativeId, WatchCreativeRequest content) throws IOException {
                Watch result = new Watch(accountId, creativeId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public DealAssociations dealAssociations() {
                return new DealAssociations();
            }

            public class DealAssociations {
                public Add add(String accountId, String creativeId, AddDealAssociationRequest content) throws IOException {
                    Add result = new Add(accountId, creativeId, content);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String accountId, String creativeId) throws IOException {
                    List result = new List(accountId, creativeId);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Remove remove(String accountId, String creativeId, RemoveDealAssociationRequest content) throws IOException {
                    Remove result = new Remove(accountId, creativeId, content);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Remove
                extends AdExchangeBuyerIIRequest<Empty> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations:remove";
                    @Key
                    private String accountId;
                    @Key
                    private String creativeId;

                    protected Remove(String accountId, String creativeId, RemoveDealAssociationRequest content) {
                        super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                    }

                    public Remove set$Xgafv(String $Xgafv) {
                        return (Remove)super.set$Xgafv($Xgafv);
                    }

                    public Remove setAccessToken(String accessToken) {
                        return (Remove)super.setAccessToken(accessToken);
                    }

                    public Remove setAlt(String alt) {
                        return (Remove)super.setAlt(alt);
                    }

                    public Remove setCallback(String callback) {
                        return (Remove)super.setCallback(callback);
                    }

                    public Remove setFields(String fields) {
                        return (Remove)super.setFields(fields);
                    }

                    public Remove setKey(String key) {
                        return (Remove)super.setKey(key);
                    }

                    public Remove setOauthToken(String oauthToken) {
                        return (Remove)super.setOauthToken(oauthToken);
                    }

                    public Remove setPrettyPrint(Boolean prettyPrint) {
                        return (Remove)super.setPrettyPrint(prettyPrint);
                    }

                    public Remove setQuotaUser(String quotaUser) {
                        return (Remove)super.setQuotaUser(quotaUser);
                    }

                    public Remove setUploadType(String uploadType) {
                        return (Remove)super.setUploadType(uploadType);
                    }

                    public Remove setUploadProtocol(String uploadProtocol) {
                        return (Remove)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getAccountId() {
                        return this.accountId;
                    }

                    public Remove setAccountId(String accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public String getCreativeId() {
                        return this.creativeId;
                    }

                    public Remove setCreativeId(String creativeId) {
                        this.creativeId = creativeId;
                        return this;
                    }

                    @Override
                    public Remove set(String parameterName, Object value) {
                        return (Remove)super.set(parameterName, value);
                    }
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListDealAssociationsResponse> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations";
                    @Key
                    private String accountId;
                    @Key
                    private String creativeId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String query;

                    protected List(String accountId, String creativeId) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListDealAssociationsResponse.class);
                        this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getAccountId() {
                        return this.accountId;
                    }

                    public List setAccountId(String accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public String getCreativeId() {
                        return this.creativeId;
                    }

                    public List setCreativeId(String creativeId) {
                        this.creativeId = creativeId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getQuery() {
                        return this.query;
                    }

                    public List setQuery(String query) {
                        this.query = query;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Add
                extends AdExchangeBuyerIIRequest<Empty> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations:add";
                    @Key
                    private String accountId;
                    @Key
                    private String creativeId;

                    protected Add(String accountId, String creativeId, AddDealAssociationRequest content) {
                        super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                    }

                    public Add set$Xgafv(String $Xgafv) {
                        return (Add)super.set$Xgafv($Xgafv);
                    }

                    public Add setAccessToken(String accessToken) {
                        return (Add)super.setAccessToken(accessToken);
                    }

                    public Add setAlt(String alt) {
                        return (Add)super.setAlt(alt);
                    }

                    public Add setCallback(String callback) {
                        return (Add)super.setCallback(callback);
                    }

                    public Add setFields(String fields) {
                        return (Add)super.setFields(fields);
                    }

                    public Add setKey(String key) {
                        return (Add)super.setKey(key);
                    }

                    public Add setOauthToken(String oauthToken) {
                        return (Add)super.setOauthToken(oauthToken);
                    }

                    public Add setPrettyPrint(Boolean prettyPrint) {
                        return (Add)super.setPrettyPrint(prettyPrint);
                    }

                    public Add setQuotaUser(String quotaUser) {
                        return (Add)super.setQuotaUser(quotaUser);
                    }

                    public Add setUploadType(String uploadType) {
                        return (Add)super.setUploadType(uploadType);
                    }

                    public Add setUploadProtocol(String uploadProtocol) {
                        return (Add)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getAccountId() {
                        return this.accountId;
                    }

                    public Add setAccountId(String accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public String getCreativeId() {
                        return this.creativeId;
                    }

                    public Add setCreativeId(String creativeId) {
                        this.creativeId = creativeId;
                        return this;
                    }

                    @Override
                    public Add set(String parameterName, Object value) {
                        return (Add)super.set(parameterName, value);
                    }
                }
            }

            public class Watch
            extends AdExchangeBuyerIIRequest<Empty> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}:watch";
                @Key
                private String accountId;
                @Key
                private String creativeId;

                protected Watch(String accountId, String creativeId, WatchCreativeRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Watch set$Xgafv(String $Xgafv) {
                    return (Watch)super.set$Xgafv($Xgafv);
                }

                public Watch setAccessToken(String accessToken) {
                    return (Watch)super.setAccessToken(accessToken);
                }

                public Watch setAlt(String alt) {
                    return (Watch)super.setAlt(alt);
                }

                public Watch setCallback(String callback) {
                    return (Watch)super.setCallback(callback);
                }

                public Watch setFields(String fields) {
                    return (Watch)super.setFields(fields);
                }

                public Watch setKey(String key) {
                    return (Watch)super.setKey(key);
                }

                public Watch setOauthToken(String oauthToken) {
                    return (Watch)super.setOauthToken(oauthToken);
                }

                public Watch setPrettyPrint(Boolean prettyPrint) {
                    return (Watch)super.setPrettyPrint(prettyPrint);
                }

                public Watch setQuotaUser(String quotaUser) {
                    return (Watch)super.setQuotaUser(quotaUser);
                }

                public Watch setUploadType(String uploadType) {
                    return (Watch)super.setUploadType(uploadType);
                }

                public Watch setUploadProtocol(String uploadProtocol) {
                    return (Watch)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Watch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getCreativeId() {
                    return this.creativeId;
                }

                public Watch setCreativeId(String creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Watch set(String parameterName, Object value) {
                    return (Watch)super.set(parameterName, value);
                }
            }

            public class Update
            extends AdExchangeBuyerIIRequest<Creative> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}";
                @Key
                private String accountId;
                @Key
                private String creativeId;

                protected Update(String accountId, String creativeId, Creative content) {
                    super(AdExchangeBuyerII.this, "PUT", REST_PATH, (Object)content, Creative.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getCreativeId() {
                    return this.creativeId;
                }

                public Update setCreativeId(String creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class StopWatching
            extends AdExchangeBuyerIIRequest<Empty> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}:stopWatching";
                @Key
                private String accountId;
                @Key
                private String creativeId;

                protected StopWatching(String accountId, String creativeId, StopWatchingCreativeRequest content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public StopWatching set$Xgafv(String $Xgafv) {
                    return (StopWatching)super.set$Xgafv($Xgafv);
                }

                public StopWatching setAccessToken(String accessToken) {
                    return (StopWatching)super.setAccessToken(accessToken);
                }

                public StopWatching setAlt(String alt) {
                    return (StopWatching)super.setAlt(alt);
                }

                public StopWatching setCallback(String callback) {
                    return (StopWatching)super.setCallback(callback);
                }

                public StopWatching setFields(String fields) {
                    return (StopWatching)super.setFields(fields);
                }

                public StopWatching setKey(String key) {
                    return (StopWatching)super.setKey(key);
                }

                public StopWatching setOauthToken(String oauthToken) {
                    return (StopWatching)super.setOauthToken(oauthToken);
                }

                public StopWatching setPrettyPrint(Boolean prettyPrint) {
                    return (StopWatching)super.setPrettyPrint(prettyPrint);
                }

                public StopWatching setQuotaUser(String quotaUser) {
                    return (StopWatching)super.setQuotaUser(quotaUser);
                }

                public StopWatching setUploadType(String uploadType) {
                    return (StopWatching)super.setUploadType(uploadType);
                }

                public StopWatching setUploadProtocol(String uploadProtocol) {
                    return (StopWatching)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public StopWatching setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getCreativeId() {
                    return this.creativeId;
                }

                public StopWatching setCreativeId(String creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public StopWatching set(String parameterName, Object value) {
                    return (StopWatching)super.set(parameterName, value);
                }
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListCreativesResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives";
                @Key
                private String accountId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String query;

                protected List(String accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListCreativesResponse.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public List setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<Creative> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives/{creativeId}";
                @Key
                private String accountId;
                @Key
                private String creativeId;

                protected Get(String accountId, String creativeId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, Creative.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.creativeId = (String)Preconditions.checkNotNull((Object)creativeId, (Object)"Required parameter creativeId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getCreativeId() {
                    return this.creativeId;
                }

                public Get setCreativeId(String creativeId) {
                    this.creativeId = creativeId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdExchangeBuyerIIRequest<Creative> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/creatives";
                @Key
                private String accountId;
                @Key
                private String duplicateIdMode;

                protected Create(String accountId, Creative content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Creative.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getDuplicateIdMode() {
                    return this.duplicateIdMode;
                }

                public Create setDuplicateIdMode(String duplicateIdMode) {
                    this.duplicateIdMode = duplicateIdMode;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Clients {
            public Create create(Long accountId, Client content) throws IOException {
                Create result = new Create(accountId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long accountId, Long clientAccountId) throws IOException {
                Get result = new Get(accountId, clientAccountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long accountId) throws IOException {
                List result = new List(accountId);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(Long accountId, Long clientAccountId, Client content) throws IOException {
                Update result = new Update(accountId, clientAccountId, content);
                AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Invitations invitations() {
                return new Invitations();
            }

            public Users users() {
                return new Users();
            }

            public class Users {
                public Get get(Long accountId, Long clientAccountId, Long userId) throws IOException {
                    Get result = new Get(accountId, clientAccountId, userId);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long accountId, String clientAccountId) throws IOException {
                    List result = new List(accountId, clientAccountId);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(Long accountId, Long clientAccountId, Long userId, ClientUser content) throws IOException {
                    Update result = new Update(accountId, clientAccountId, userId, content);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Update
                extends AdExchangeBuyerIIRequest<ClientUser> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/users/{userId}";
                    @Key
                    private Long accountId;
                    @Key
                    private Long clientAccountId;
                    @Key
                    private Long userId;

                    protected Update(Long accountId, Long clientAccountId, Long userId, ClientUser content) {
                        super(AdExchangeBuyerII.this, "PUT", REST_PATH, (Object)content, ClientUser.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                        this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public Update setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public Long getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public Update setClientAccountId(Long clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    public Long getUserId() {
                        return this.userId;
                    }

                    public Update setUserId(Long userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListClientUsersResponse> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/users";
                    @Key
                    private Long accountId;
                    @Key
                    private String clientAccountId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long accountId, String clientAccountId) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListClientUsersResponse.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (String)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public List setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public String getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public List setClientAccountId(String clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends AdExchangeBuyerIIRequest<ClientUser> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/users/{userId}";
                    @Key
                    private Long accountId;
                    @Key
                    private Long clientAccountId;
                    @Key
                    private Long userId;

                    protected Get(Long accountId, Long clientAccountId, Long userId) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ClientUser.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                        this.userId = (Long)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public Get setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public Long getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public Get setClientAccountId(Long clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    public Long getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(Long userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Invitations {
                public Create create(Long accountId, Long clientAccountId, ClientUserInvitation content) throws IOException {
                    Create result = new Create(accountId, clientAccountId, content);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(Long accountId, Long clientAccountId, Long invitationId) throws IOException {
                    Get result = new Get(accountId, clientAccountId, invitationId);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(Long accountId, String clientAccountId) throws IOException {
                    List result = new List(accountId, clientAccountId);
                    AdExchangeBuyerII.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdExchangeBuyerIIRequest<ListClientUserInvitationsResponse> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations";
                    @Key
                    private Long accountId;
                    @Key
                    private String clientAccountId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(Long accountId, String clientAccountId) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListClientUserInvitationsResponse.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (String)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public List setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public String getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public List setClientAccountId(String clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends AdExchangeBuyerIIRequest<ClientUserInvitation> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations/{invitationId}";
                    @Key
                    private Long accountId;
                    @Key
                    private Long clientAccountId;
                    @Key
                    private Long invitationId;

                    protected Get(Long accountId, Long clientAccountId, Long invitationId) {
                        super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ClientUserInvitation.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                        this.invitationId = (Long)Preconditions.checkNotNull((Object)invitationId, (Object)"Required parameter invitationId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public Get setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public Long getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public Get setClientAccountId(Long clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    public Long getInvitationId() {
                        return this.invitationId;
                    }

                    public Get setInvitationId(Long invitationId) {
                        this.invitationId = invitationId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends AdExchangeBuyerIIRequest<ClientUserInvitation> {
                    private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations";
                    @Key
                    private Long accountId;
                    @Key
                    private Long clientAccountId;

                    protected Create(Long accountId, Long clientAccountId, ClientUserInvitation content) {
                        super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, ClientUserInvitation.class);
                        this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                        this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public Long getAccountId() {
                        return this.accountId;
                    }

                    public Create setAccountId(Long accountId) {
                        this.accountId = accountId;
                        return this;
                    }

                    public Long getClientAccountId() {
                        return this.clientAccountId;
                    }

                    public Create setClientAccountId(Long clientAccountId) {
                        this.clientAccountId = clientAccountId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends AdExchangeBuyerIIRequest<Client> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long clientAccountId;

                protected Update(Long accountId, Long clientAccountId, Client content) {
                    super(AdExchangeBuyerII.this, "PUT", REST_PATH, (Object)content, Client.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getClientAccountId() {
                    return this.clientAccountId;
                }

                public Update setClientAccountId(Long clientAccountId) {
                    this.clientAccountId = clientAccountId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends AdExchangeBuyerIIRequest<ListClientsResponse> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients";
                @Key
                private Long accountId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String partnerClientId;

                protected List(Long accountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, ListClientsResponse.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getPartnerClientId() {
                    return this.partnerClientId;
                }

                public List setPartnerClientId(String partnerClientId) {
                    this.partnerClientId = partnerClientId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AdExchangeBuyerIIRequest<Client> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients/{clientAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long clientAccountId;

                protected Get(Long accountId, Long clientAccountId) {
                    super(AdExchangeBuyerII.this, "GET", REST_PATH, null, Client.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.clientAccountId = (Long)Preconditions.checkNotNull((Object)clientAccountId, (Object)"Required parameter clientAccountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getClientAccountId() {
                    return this.clientAccountId;
                }

                public Get setClientAccountId(Long clientAccountId) {
                    this.clientAccountId = clientAccountId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdExchangeBuyerIIRequest<Client> {
                private static final String REST_PATH = "v2beta1/accounts/{accountId}/clients";
                @Key
                private Long accountId;

                protected Create(Long accountId, Client content) {
                    super(AdExchangeBuyerII.this, "POST", REST_PATH, (Object)content, Client.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }
}

