/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1.model;

/**
 * The streaming response for the AdMob Network report where the first response contains the report
 * header, then a stream of row responses, and finally a footer as the last response message.
 *
 * For example:
 *
 *     [{       "header": {         "dateRange": {           "startDate": {"year": 2018, "month": 9,
 * "day": 1},           "endDate": {"year": 2018, "month": 9, "day": 30}         }
 * "localizationSettings": {           "currencyCode": "USD",           "languageCode": "en-US"
 * }       }     },     {       "row": {         "dimensionValues": {           "DATE": {"value":
 * "20180918"},           "APP": {             "value": "ca-app-pub-8123415297019784~1001342552",
 * displayLabel: "My app name!"           }         },         "metricValues": {
 * "ESTIMATED_EARNINGS": {"microsValue": 6500000}         }       }     },     ...     {
 * "footer": {"matchingRowCount": 5}     }]
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenerateNetworkReportResponse extends com.google.api.client.json.GenericJson {

  /**
   * Additional information about the generated report, such as warnings about the data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportFooter footer;

  /**
   * Report generation settings that describes the report contents, such as the report date range
   * and localization settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportHeader header;

  /**
   * Actual report data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportRow row;

  /**
   * Additional information about the generated report, such as warnings about the data.
   * @return value or {@code null} for none
   */
  public ReportFooter getFooter() {
    return footer;
  }

  /**
   * Additional information about the generated report, such as warnings about the data.
   * @param footer footer or {@code null} for none
   */
  public GenerateNetworkReportResponse setFooter(ReportFooter footer) {
    this.footer = footer;
    return this;
  }

  /**
   * Report generation settings that describes the report contents, such as the report date range
   * and localization settings.
   * @return value or {@code null} for none
   */
  public ReportHeader getHeader() {
    return header;
  }

  /**
   * Report generation settings that describes the report contents, such as the report date range
   * and localization settings.
   * @param header header or {@code null} for none
   */
  public GenerateNetworkReportResponse setHeader(ReportHeader header) {
    this.header = header;
    return this;
  }

  /**
   * Actual report data.
   * @return value or {@code null} for none
   */
  public ReportRow getRow() {
    return row;
  }

  /**
   * Actual report data.
   * @param row row or {@code null} for none
   */
  public GenerateNetworkReportResponse setRow(ReportRow row) {
    this.row = row;
    return this;
  }

  @Override
  public GenerateNetworkReportResponse set(String fieldName, Object value) {
    return (GenerateNetworkReportResponse) super.set(fieldName, value);
  }

  @Override
  public GenerateNetworkReportResponse clone() {
    return (GenerateNetworkReportResponse) super.clone();
  }

}
