/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1.model;

/**
 * Groups data helps to treat the generated report. Always sent as a first message in the stream
 * response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportHeader extends com.google.api.client.json.GenericJson {

  /**
   * The date range for which the report is generated. This is identical to the range specified in
   * the report request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateRange dateRange;

  /**
   * Localization settings of the report. This is identical to the settings in the report request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizationSettings localizationSettings;

  /**
   * The report time zone. The value is a time-zone ID as specified by the CLDR project, for
   * example, "America/Los_Angeles".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportingTimeZone;

  /**
   * The date range for which the report is generated. This is identical to the range specified in
   * the report request.
   * @return value or {@code null} for none
   */
  public DateRange getDateRange() {
    return dateRange;
  }

  /**
   * The date range for which the report is generated. This is identical to the range specified in
   * the report request.
   * @param dateRange dateRange or {@code null} for none
   */
  public ReportHeader setDateRange(DateRange dateRange) {
    this.dateRange = dateRange;
    return this;
  }

  /**
   * Localization settings of the report. This is identical to the settings in the report request.
   * @return value or {@code null} for none
   */
  public LocalizationSettings getLocalizationSettings() {
    return localizationSettings;
  }

  /**
   * Localization settings of the report. This is identical to the settings in the report request.
   * @param localizationSettings localizationSettings or {@code null} for none
   */
  public ReportHeader setLocalizationSettings(LocalizationSettings localizationSettings) {
    this.localizationSettings = localizationSettings;
    return this;
  }

  /**
   * The report time zone. The value is a time-zone ID as specified by the CLDR project, for
   * example, "America/Los_Angeles".
   * @return value or {@code null} for none
   */
  public java.lang.String getReportingTimeZone() {
    return reportingTimeZone;
  }

  /**
   * The report time zone. The value is a time-zone ID as specified by the CLDR project, for
   * example, "America/Los_Angeles".
   * @param reportingTimeZone reportingTimeZone or {@code null} for none
   */
  public ReportHeader setReportingTimeZone(java.lang.String reportingTimeZone) {
    this.reportingTimeZone = reportingTimeZone;
    return this;
  }

  @Override
  public ReportHeader set(String fieldName, Object value) {
    return (ReportHeader) super.set(fieldName, value);
  }

  @Override
  public ReportHeader clone() {
    return (ReportHeader) super.clone();
  }

}
