/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1.model;

/**
 * Response for the apps list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAppsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The resulting apps for the requested account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<App> apps;

  static {
    // hack to force ProGuard to consider App used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(App.class);
  }

  /**
   * If not empty, indicates that there may be more apps for the request; this value should be
   * passed in a new `ListAppsRequest`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The resulting apps for the requested account.
   * @return value or {@code null} for none
   */
  public java.util.List<App> getApps() {
    return apps;
  }

  /**
   * The resulting apps for the requested account.
   * @param apps apps or {@code null} for none
   */
  public ListAppsResponse setApps(java.util.List<App> apps) {
    this.apps = apps;
    return this;
  }

  /**
   * If not empty, indicates that there may be more apps for the request; this value should be
   * passed in a new `ListAppsRequest`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more apps for the request; this value should be
   * passed in a new `ListAppsRequest`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAppsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAppsResponse set(String fieldName, Object value) {
    return (ListAppsResponse) super.set(fieldName, value);
  }

  @Override
  public ListAppsResponse clone() {
    return (ListAppsResponse) super.clone();
  }

}
