/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-06 at 01:51:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1.model;

/**
 * Localization settings for reports, such as currency and language. It affects how metrics are
 * calculated.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalizationSettings extends com.google.api.client.json.GenericJson {

  /**
   * Currency code of the earning related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion. Defaults to the account currency
   * code if unspecified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * Language used for any localized text, such as some dimension value display labels. The language
   * tag defined in the IETF BCP47. Defaults to 'en-US' if unspecified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Currency code of the earning related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion. Defaults to the account currency
   * code if unspecified.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * Currency code of the earning related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion. Defaults to the account currency
   * code if unspecified.
   * @param currencyCode currencyCode or {@code null} for none
   */
  public LocalizationSettings setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Language used for any localized text, such as some dimension value display labels. The language
   * tag defined in the IETF BCP47. Defaults to 'en-US' if unspecified.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Language used for any localized text, such as some dimension value display labels. The language
   * tag defined in the IETF BCP47. Defaults to 'en-US' if unspecified.
   * @param languageCode languageCode or {@code null} for none
   */
  public LocalizationSettings setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  @Override
  public LocalizationSettings set(String fieldName, Object value) {
    return (LocalizationSettings) super.set(fieldName, value);
  }

  @Override
  public LocalizationSettings clone() {
    return (LocalizationSettings) super.clone();
  }

}
