/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-06 at 01:51:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1.model;

/**
 * A row of the returning report.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportRow extends com.google.api.client.json.GenericJson {

  /**
   * Map of dimension values in a row, with keys as enum name of the dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ReportRowDimensionValue> dimensionValues;

  static {
    // hack to force ProGuard to consider ReportRowDimensionValue used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ReportRowDimensionValue.class);
  }

  /**
   * Map of metric values in a row, with keys as enum name of the metrics. If a metric being
   * requested has no value returned, the map will not include it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ReportRowMetricValue> metricValues;

  static {
    // hack to force ProGuard to consider ReportRowMetricValue used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ReportRowMetricValue.class);
  }

  /**
   * Map of dimension values in a row, with keys as enum name of the dimensions.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ReportRowDimensionValue> getDimensionValues() {
    return dimensionValues;
  }

  /**
   * Map of dimension values in a row, with keys as enum name of the dimensions.
   * @param dimensionValues dimensionValues or {@code null} for none
   */
  public ReportRow setDimensionValues(java.util.Map<String, ReportRowDimensionValue> dimensionValues) {
    this.dimensionValues = dimensionValues;
    return this;
  }

  /**
   * Map of metric values in a row, with keys as enum name of the metrics. If a metric being
   * requested has no value returned, the map will not include it.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ReportRowMetricValue> getMetricValues() {
    return metricValues;
  }

  /**
   * Map of metric values in a row, with keys as enum name of the metrics. If a metric being
   * requested has no value returned, the map will not include it.
   * @param metricValues metricValues or {@code null} for none
   */
  public ReportRow setMetricValues(java.util.Map<String, ReportRowMetricValue> metricValues) {
    this.metricValues = metricValues;
    return this;
  }

  @Override
  public ReportRow set(String fieldName, Object value) {
    return (ReportRow) super.set(fieldName, value);
  }

  @Override
  public ReportRow clone() {
    return (ReportRow) super.clone();
  }

}
