/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admob.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admob.v1.AdMobRequest;
import com.google.api.services.admob.v1.AdMobRequestInitializer;
import com.google.api.services.admob.v1.model.GenerateMediationReportRequest;
import com.google.api.services.admob.v1.model.GenerateMediationReportResponse;
import com.google.api.services.admob.v1.model.GenerateNetworkReportRequest;
import com.google.api.services.admob.v1.model.GenerateNetworkReportResponse;
import com.google.api.services.admob.v1.model.ListPublisherAccountsResponse;
import com.google.api.services.admob.v1.model.PublisherAccount;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdMob
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://admob.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://admob.googleapis.com/";

    public AdMob(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    AdMob(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.18.0-rc of the AdMob API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://admob.googleapis.com/", AdMob.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public AdMob build() {
            return new AdMob(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAdMobRequestInitializer(AdMobRequestInitializer adMobRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)adMobRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Accounts {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public MediationReport mediationReport() {
            return new MediationReport();
        }

        public NetworkReport networkReport() {
            return new NetworkReport();
        }

        public class NetworkReport {
            public Generate generate(String string, GenerateNetworkReportRequest generateNetworkReportRequest) throws IOException {
                Generate generate = new Generate(string, generateNetworkReportRequest);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)generate);
                return generate;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Generate
            extends AdMobRequest<GenerateNetworkReportResponse> {
                private static final String REST_PATH = "v1/{+parent}/networkReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String string, GenerateNetworkReportRequest generateNetworkReportRequest) {
                    super(AdMob.this, "POST", REST_PATH, (Object)generateNetworkReportRequest, GenerateNetworkReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String string) {
                    return (Generate)super.set$Xgafv(string);
                }

                public Generate setAccessToken(String string) {
                    return (Generate)super.setAccessToken(string);
                }

                public Generate setAlt(String string) {
                    return (Generate)super.setAlt(string);
                }

                public Generate setCallback(String string) {
                    return (Generate)super.setCallback(string);
                }

                public Generate setFields(String string) {
                    return (Generate)super.setFields(string);
                }

                public Generate setKey(String string) {
                    return (Generate)super.setKey(string);
                }

                public Generate setOauthToken(String string) {
                    return (Generate)super.setOauthToken(string);
                }

                public Generate setPrettyPrint(Boolean bl) {
                    return (Generate)super.setPrettyPrint(bl);
                }

                public Generate setQuotaUser(String string) {
                    return (Generate)super.setQuotaUser(string);
                }

                public Generate setUploadType(String string) {
                    return (Generate)super.setUploadType(string);
                }

                public Generate setUploadProtocol(String string) {
                    return (Generate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String string) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Generate set(String string, Object object) {
                    return (Generate)super.set(string, object);
                }
            }
        }

        public class MediationReport {
            public Generate generate(String string, GenerateMediationReportRequest generateMediationReportRequest) throws IOException {
                Generate generate = new Generate(string, generateMediationReportRequest);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)generate);
                return generate;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Generate
            extends AdMobRequest<GenerateMediationReportResponse> {
                private static final String REST_PATH = "v1/{+parent}/mediationReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String string, GenerateMediationReportRequest generateMediationReportRequest) {
                    super(AdMob.this, "POST", REST_PATH, (Object)generateMediationReportRequest, GenerateMediationReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String string) {
                    return (Generate)super.set$Xgafv(string);
                }

                public Generate setAccessToken(String string) {
                    return (Generate)super.setAccessToken(string);
                }

                public Generate setAlt(String string) {
                    return (Generate)super.setAlt(string);
                }

                public Generate setCallback(String string) {
                    return (Generate)super.setCallback(string);
                }

                public Generate setFields(String string) {
                    return (Generate)super.setFields(string);
                }

                public Generate setKey(String string) {
                    return (Generate)super.setKey(string);
                }

                public Generate setOauthToken(String string) {
                    return (Generate)super.setOauthToken(string);
                }

                public Generate setPrettyPrint(Boolean bl) {
                    return (Generate)super.setPrettyPrint(bl);
                }

                public Generate setQuotaUser(String string) {
                    return (Generate)super.setQuotaUser(string);
                }

                public Generate setUploadType(String string) {
                    return (Generate)super.setUploadType(string);
                }

                public Generate setUploadProtocol(String string) {
                    return (Generate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String string) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Generate set(String string, Object object) {
                    return (Generate)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends AdMobRequest<ListPublisherAccountsResponse> {
            private static final String REST_PATH = "v1/accounts";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(AdMob.this, "GET", REST_PATH, null, ListPublisherAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AdMobRequest<PublisherAccount> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(AdMob.this, "GET", REST_PATH, null, PublisherAccount.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

