/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * A publisher account contains information relevant to the use of this API, such as the time zone
 * used for the reports.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublisherAccount extends com.google.api.client.json.GenericJson {

  /**
   * Currency code of the earning-related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * Resource name of this account. Format is accounts/{publisher_id}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The unique ID by which this publisher account can be identified in the API requests (for
   * example, pub-1234567890).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publisherId;

  /**
   * The time zone that is used in reports that are generated for this account. The value is a time-
   * zone ID as specified by the CLDR project, for example, "America/Los_Angeles".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportingTimeZone;

  /**
   * Currency code of the earning-related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * Currency code of the earning-related metrics, which is the 3-letter code defined in ISO 4217.
   * The daily average rate is used for the currency conversion.
   * @param currencyCode currencyCode or {@code null} for none
   */
  public PublisherAccount setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Resource name of this account. Format is accounts/{publisher_id}.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of this account. Format is accounts/{publisher_id}.
   * @param name name or {@code null} for none
   */
  public PublisherAccount setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The unique ID by which this publisher account can be identified in the API requests (for
   * example, pub-1234567890).
   * @return value or {@code null} for none
   */
  public java.lang.String getPublisherId() {
    return publisherId;
  }

  /**
   * The unique ID by which this publisher account can be identified in the API requests (for
   * example, pub-1234567890).
   * @param publisherId publisherId or {@code null} for none
   */
  public PublisherAccount setPublisherId(java.lang.String publisherId) {
    this.publisherId = publisherId;
    return this;
  }

  /**
   * The time zone that is used in reports that are generated for this account. The value is a time-
   * zone ID as specified by the CLDR project, for example, "America/Los_Angeles".
   * @return value or {@code null} for none
   */
  public java.lang.String getReportingTimeZone() {
    return reportingTimeZone;
  }

  /**
   * The time zone that is used in reports that are generated for this account. The value is a time-
   * zone ID as specified by the CLDR project, for example, "America/Los_Angeles".
   * @param reportingTimeZone reportingTimeZone or {@code null} for none
   */
  public PublisherAccount setReportingTimeZone(java.lang.String reportingTimeZone) {
    this.reportingTimeZone = reportingTimeZone;
    return this;
  }

  @Override
  public PublisherAccount set(String fieldName, Object value) {
    return (PublisherAccount) super.set(fieldName, value);
  }

  @Override
  public PublisherAccount clone() {
    return (PublisherAccount) super.clone();
  }

}
