/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admob.v1beta;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admob.v1beta.AdMobRequest;
import com.google.api.services.admob.v1beta.AdMobRequestInitializer;
import com.google.api.services.admob.v1beta.model.GenerateMediationReportRequest;
import com.google.api.services.admob.v1beta.model.GenerateMediationReportResponse;
import com.google.api.services.admob.v1beta.model.GenerateNetworkReportRequest;
import com.google.api.services.admob.v1beta.model.GenerateNetworkReportResponse;
import com.google.api.services.admob.v1beta.model.ListAdUnitsResponse;
import com.google.api.services.admob.v1beta.model.ListAppsResponse;
import com.google.api.services.admob.v1beta.model.ListPublisherAccountsResponse;
import com.google.api.services.admob.v1beta.model.PublisherAccount;
import java.io.IOException;
import java.util.regex.Pattern;

public class AdMob
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://admob.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://admob.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://admob.googleapis.com/";

    public AdMob(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AdMob(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the AdMob API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AdMob.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://admob.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AdMob.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AdMob.DEFAULT_BATCH_PATH);
        }

        public AdMob build() {
            return new AdMob(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAdMobRequestInitializer(AdMobRequestInitializer admobRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)admobRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Accounts {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AdUnits adUnits() {
            return new AdUnits();
        }

        public Apps apps() {
            return new Apps();
        }

        public MediationReport mediationReport() {
            return new MediationReport();
        }

        public NetworkReport networkReport() {
            return new NetworkReport();
        }

        public class NetworkReport {
            public Generate generate(String parent, GenerateNetworkReportRequest content) throws IOException {
                Generate result = new Generate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Generate
            extends AdMobRequest<GenerateNetworkReportResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/networkReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String parent, GenerateNetworkReportRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, GenerateNetworkReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String $Xgafv) {
                    return (Generate)super.set$Xgafv($Xgafv);
                }

                public Generate setAccessToken(String accessToken) {
                    return (Generate)super.setAccessToken(accessToken);
                }

                public Generate setAlt(String alt) {
                    return (Generate)super.setAlt(alt);
                }

                public Generate setCallback(String callback) {
                    return (Generate)super.setCallback(callback);
                }

                public Generate setFields(String fields) {
                    return (Generate)super.setFields(fields);
                }

                public Generate setKey(String key) {
                    return (Generate)super.setKey(key);
                }

                public Generate setOauthToken(String oauthToken) {
                    return (Generate)super.setOauthToken(oauthToken);
                }

                public Generate setPrettyPrint(Boolean prettyPrint) {
                    return (Generate)super.setPrettyPrint(prettyPrint);
                }

                public Generate setQuotaUser(String quotaUser) {
                    return (Generate)super.setQuotaUser(quotaUser);
                }

                public Generate setUploadType(String uploadType) {
                    return (Generate)super.setUploadType(uploadType);
                }

                public Generate setUploadProtocol(String uploadProtocol) {
                    return (Generate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Generate set(String parameterName, Object value) {
                    return (Generate)super.set(parameterName, value);
                }
            }
        }

        public class MediationReport {
            public Generate generate(String parent, GenerateMediationReportRequest content) throws IOException {
                Generate result = new Generate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Generate
            extends AdMobRequest<GenerateMediationReportResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/mediationReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String parent, GenerateMediationReportRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, GenerateMediationReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String $Xgafv) {
                    return (Generate)super.set$Xgafv($Xgafv);
                }

                public Generate setAccessToken(String accessToken) {
                    return (Generate)super.setAccessToken(accessToken);
                }

                public Generate setAlt(String alt) {
                    return (Generate)super.setAlt(alt);
                }

                public Generate setCallback(String callback) {
                    return (Generate)super.setCallback(callback);
                }

                public Generate setFields(String fields) {
                    return (Generate)super.setFields(fields);
                }

                public Generate setKey(String key) {
                    return (Generate)super.setKey(key);
                }

                public Generate setOauthToken(String oauthToken) {
                    return (Generate)super.setOauthToken(oauthToken);
                }

                public Generate setPrettyPrint(Boolean prettyPrint) {
                    return (Generate)super.setPrettyPrint(prettyPrint);
                }

                public Generate setQuotaUser(String quotaUser) {
                    return (Generate)super.setQuotaUser(quotaUser);
                }

                public Generate setUploadType(String uploadType) {
                    return (Generate)super.setUploadType(uploadType);
                }

                public Generate setUploadProtocol(String uploadProtocol) {
                    return (Generate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Generate set(String parameterName, Object value) {
                    return (Generate)super.set(parameterName, value);
                }
            }
        }

        public class Apps {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AdMobRequest<ListAppsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/apps";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListAppsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class AdUnits {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AdMobRequest<ListAdUnitsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/adUnits";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListAdUnitsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends AdMobRequest<ListPublisherAccountsResponse> {
            private static final String REST_PATH = "v1beta/accounts";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(AdMob.this, "GET", REST_PATH, null, ListPublisherAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends AdMobRequest<PublisherAccount> {
            private static final String REST_PATH = "v1beta/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(AdMob.this, "GET", REST_PATH, null, PublisherAccount.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

