/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Describes an AdMob ad unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdUnit extends com.google.api.client.json.GenericJson {

  /**
   * AdFormat of the ad unit. Possible values are as follows: "APP_OPEN" - App Open ad format.
   * "BANNER" - Banner ad format. "BANNER_INTERSTITIAL" - Legacy format that can be used as either
   * banner or interstitial. This format can no longer be created but can be targeted by mediation
   * groups. "INTERSTITIAL" - A full screen ad. Supported ad types are "RICH_MEDIA" and "VIDEO".
   * "NATIVE" - Native ad format. "REWARDED" - An ad that, once viewed, gets a callback verifying
   * the view so that a reward can be given to the user. Supported ad types are "RICH_MEDIA"
   * (interactive) and video where video can not be excluded. "REWARDED_INTERSTITIAL" - Rewarded
   * Interstitial ad format. Only supports video ad type. See
   * https://support.google.com/admob/answer/9884467.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adFormat;

  /**
   * Ad media type supported by this ad unit. Possible values as follows: "RICH_MEDIA" - Text,
   * image, and other non-video media. "VIDEO" - Video media.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> adTypes;

  /**
   * The externally visible ID of the ad unit which can be used to integrate with the AdMob SDK.
   * This is a read only property. Example: ca-app-pub-9876543210987654/0123456789
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adUnitId;

  /**
   * The externally visible ID of the app this ad unit is associated with. Example: ca-app-
   * pub-9876543210987654~0123456789
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appId;

  /**
   * The display name of the ad unit as shown in the AdMob UI, which is provided by the user. The
   * maximum length allowed is 80 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Resource name for this ad unit. Format is accounts/{publisher_id}/adUnits/{ad_unit_id_fragment}
   * Example: accounts/pub-9876543210987654/adUnits/0123456789
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * AdFormat of the ad unit. Possible values are as follows: "APP_OPEN" - App Open ad format.
   * "BANNER" - Banner ad format. "BANNER_INTERSTITIAL" - Legacy format that can be used as either
   * banner or interstitial. This format can no longer be created but can be targeted by mediation
   * groups. "INTERSTITIAL" - A full screen ad. Supported ad types are "RICH_MEDIA" and "VIDEO".
   * "NATIVE" - Native ad format. "REWARDED" - An ad that, once viewed, gets a callback verifying
   * the view so that a reward can be given to the user. Supported ad types are "RICH_MEDIA"
   * (interactive) and video where video can not be excluded. "REWARDED_INTERSTITIAL" - Rewarded
   * Interstitial ad format. Only supports video ad type. See
   * https://support.google.com/admob/answer/9884467.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdFormat() {
    return adFormat;
  }

  /**
   * AdFormat of the ad unit. Possible values are as follows: "APP_OPEN" - App Open ad format.
   * "BANNER" - Banner ad format. "BANNER_INTERSTITIAL" - Legacy format that can be used as either
   * banner or interstitial. This format can no longer be created but can be targeted by mediation
   * groups. "INTERSTITIAL" - A full screen ad. Supported ad types are "RICH_MEDIA" and "VIDEO".
   * "NATIVE" - Native ad format. "REWARDED" - An ad that, once viewed, gets a callback verifying
   * the view so that a reward can be given to the user. Supported ad types are "RICH_MEDIA"
   * (interactive) and video where video can not be excluded. "REWARDED_INTERSTITIAL" - Rewarded
   * Interstitial ad format. Only supports video ad type. See
   * https://support.google.com/admob/answer/9884467.
   * @param adFormat adFormat or {@code null} for none
   */
  public AdUnit setAdFormat(java.lang.String adFormat) {
    this.adFormat = adFormat;
    return this;
  }

  /**
   * Ad media type supported by this ad unit. Possible values as follows: "RICH_MEDIA" - Text,
   * image, and other non-video media. "VIDEO" - Video media.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdTypes() {
    return adTypes;
  }

  /**
   * Ad media type supported by this ad unit. Possible values as follows: "RICH_MEDIA" - Text,
   * image, and other non-video media. "VIDEO" - Video media.
   * @param adTypes adTypes or {@code null} for none
   */
  public AdUnit setAdTypes(java.util.List<java.lang.String> adTypes) {
    this.adTypes = adTypes;
    return this;
  }

  /**
   * The externally visible ID of the ad unit which can be used to integrate with the AdMob SDK.
   * This is a read only property. Example: ca-app-pub-9876543210987654/0123456789
   * @return value or {@code null} for none
   */
  public java.lang.String getAdUnitId() {
    return adUnitId;
  }

  /**
   * The externally visible ID of the ad unit which can be used to integrate with the AdMob SDK.
   * This is a read only property. Example: ca-app-pub-9876543210987654/0123456789
   * @param adUnitId adUnitId or {@code null} for none
   */
  public AdUnit setAdUnitId(java.lang.String adUnitId) {
    this.adUnitId = adUnitId;
    return this;
  }

  /**
   * The externally visible ID of the app this ad unit is associated with. Example: ca-app-
   * pub-9876543210987654~0123456789
   * @return value or {@code null} for none
   */
  public java.lang.String getAppId() {
    return appId;
  }

  /**
   * The externally visible ID of the app this ad unit is associated with. Example: ca-app-
   * pub-9876543210987654~0123456789
   * @param appId appId or {@code null} for none
   */
  public AdUnit setAppId(java.lang.String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * The display name of the ad unit as shown in the AdMob UI, which is provided by the user. The
   * maximum length allowed is 80 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The display name of the ad unit as shown in the AdMob UI, which is provided by the user. The
   * maximum length allowed is 80 characters.
   * @param displayName displayName or {@code null} for none
   */
  public AdUnit setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Resource name for this ad unit. Format is accounts/{publisher_id}/adUnits/{ad_unit_id_fragment}
   * Example: accounts/pub-9876543210987654/adUnits/0123456789
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name for this ad unit. Format is accounts/{publisher_id}/adUnits/{ad_unit_id_fragment}
   * Example: accounts/pub-9876543210987654/adUnits/0123456789
   * @param name name or {@code null} for none
   */
  public AdUnit setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public AdUnit set(String fieldName, Object value) {
    return (AdUnit) super.set(fieldName, value);
  }

  @Override
  public AdUnit clone() {
    return (AdUnit) super.clone();
  }

}
