/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Definition of a mediation ad source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdSource extends com.google.api.client.json.GenericJson {

  /**
   * ID of this ad source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adSourceId;

  /**
   * Resource name of this ad source. Format is: accounts/{publisher_id}/adSources/{ad_source_id}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Display name of this ad source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * ID of this ad source.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdSourceId() {
    return adSourceId;
  }

  /**
   * ID of this ad source.
   * @param adSourceId adSourceId or {@code null} for none
   */
  public AdSource setAdSourceId(java.lang.String adSourceId) {
    this.adSourceId = adSourceId;
    return this;
  }

  /**
   * Resource name of this ad source. Format is: accounts/{publisher_id}/adSources/{ad_source_id}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of this ad source. Format is: accounts/{publisher_id}/adSources/{ad_source_id}
   * @param name name or {@code null} for none
   */
  public AdSource setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Display name of this ad source.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Display name of this ad source.
   * @param title title or {@code null} for none
   */
  public AdSource setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public AdSource set(String fieldName, Object value) {
    return (AdSource) super.set(fieldName, value);
  }

  @Override
  public AdSource clone() {
    return (AdSource) super.clone();
  }

}
