/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Settings for a rewarded ad unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdUnitRewardSettings extends com.google.api.client.json.GenericJson {

  /**
   * Reward amount for this ad unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long unitAmount;

  /**
   * Reward item for this ad unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unitType;

  /**
   * Reward amount for this ad unit.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUnitAmount() {
    return unitAmount;
  }

  /**
   * Reward amount for this ad unit.
   * @param unitAmount unitAmount or {@code null} for none
   */
  public AdUnitRewardSettings setUnitAmount(java.lang.Long unitAmount) {
    this.unitAmount = unitAmount;
    return this;
  }

  /**
   * Reward item for this ad unit.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnitType() {
    return unitType;
  }

  /**
   * Reward item for this ad unit.
   * @param unitType unitType or {@code null} for none
   */
  public AdUnitRewardSettings setUnitType(java.lang.String unitType) {
    this.unitType = unitType;
    return this;
  }

  @Override
  public AdUnitRewardSettings set(String fieldName, Object value) {
    return (AdUnitRewardSettings) super.set(fieldName, value);
  }

  @Override
  public AdUnitRewardSettings clone() {
    return (AdUnitRewardSettings) super.clone();
  }

}
