/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Describes adapters supported by each mediation ad source. Adapters correspond to a specific SDK
 * implementation of the ad source, and are each associated with a single platform and a list of
 * supported ad unit formats. Adapters may also require setting some configurations to perform ad
 * requests. Configurations can be specified in the AdUnitMapping by setting the
 * [ad_unit_configurations](#AdUnitMapping.ad_unit_configurations) key/value pairs. For example, the
 * ad_unit_configurations can be used to pass various IDs to the adapter's third-party SDK.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Adapter extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Configuration metadata associated with this adapter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdapterAdapterConfigMetadata> adapterConfigMetadata;

  /**
   * Output only. ID of this adapter. It is used to set [adapter_id](#AdUnitMapping.adapter_id).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adapterId;

  /**
   * Output only. Indicates the formats of the ad units supported by this adapter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> formats;

  /**
   * Output only. Resource name of the adapter. Format is:
   * accounts/{publisher_id}/adSources/{ad_source_id}/adapters/{adapter_id}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Mobile application platform supported by this adapter. Supported values are: IOS,
   * ANDROID, WINDOWS_PHONE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * Output only. The display name of this adapter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Output only. Configuration metadata associated with this adapter.
   * @return value or {@code null} for none
   */
  public java.util.List<AdapterAdapterConfigMetadata> getAdapterConfigMetadata() {
    return adapterConfigMetadata;
  }

  /**
   * Output only. Configuration metadata associated with this adapter.
   * @param adapterConfigMetadata adapterConfigMetadata or {@code null} for none
   */
  public Adapter setAdapterConfigMetadata(java.util.List<AdapterAdapterConfigMetadata> adapterConfigMetadata) {
    this.adapterConfigMetadata = adapterConfigMetadata;
    return this;
  }

  /**
   * Output only. ID of this adapter. It is used to set [adapter_id](#AdUnitMapping.adapter_id).
   * @return value or {@code null} for none
   */
  public java.lang.String getAdapterId() {
    return adapterId;
  }

  /**
   * Output only. ID of this adapter. It is used to set [adapter_id](#AdUnitMapping.adapter_id).
   * @param adapterId adapterId or {@code null} for none
   */
  public Adapter setAdapterId(java.lang.String adapterId) {
    this.adapterId = adapterId;
    return this;
  }

  /**
   * Output only. Indicates the formats of the ad units supported by this adapter.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFormats() {
    return formats;
  }

  /**
   * Output only. Indicates the formats of the ad units supported by this adapter.
   * @param formats formats or {@code null} for none
   */
  public Adapter setFormats(java.util.List<java.lang.String> formats) {
    this.formats = formats;
    return this;
  }

  /**
   * Output only. Resource name of the adapter. Format is:
   * accounts/{publisher_id}/adSources/{ad_source_id}/adapters/{adapter_id}.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of the adapter. Format is:
   * accounts/{publisher_id}/adSources/{ad_source_id}/adapters/{adapter_id}.
   * @param name name or {@code null} for none
   */
  public Adapter setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Mobile application platform supported by this adapter. Supported values are: IOS,
   * ANDROID, WINDOWS_PHONE
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * Output only. Mobile application platform supported by this adapter. Supported values are: IOS,
   * ANDROID, WINDOWS_PHONE
   * @param platform platform or {@code null} for none
   */
  public Adapter setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * Output only. The display name of this adapter.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Output only. The display name of this adapter.
   * @param title title or {@code null} for none
   */
  public Adapter setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public Adapter set(String fieldName, Object value) {
    return (Adapter) super.set(fieldName, value);
  }

  @Override
  public Adapter clone() {
    return (Adapter) super.clone();
  }

}
