/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Response containing a batch of created ad unit mappings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchCreateAdUnitMappingsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The Ad units mappings created under the requested account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdUnitMapping> adUnitMappings;

  static {
    // hack to force ProGuard to consider AdUnitMapping used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AdUnitMapping.class);
  }

  /**
   * The Ad units mappings created under the requested account.
   * @return value or {@code null} for none
   */
  public java.util.List<AdUnitMapping> getAdUnitMappings() {
    return adUnitMappings;
  }

  /**
   * The Ad units mappings created under the requested account.
   * @param adUnitMappings adUnitMappings or {@code null} for none
   */
  public BatchCreateAdUnitMappingsResponse setAdUnitMappings(java.util.List<AdUnitMapping> adUnitMappings) {
    this.adUnitMappings = adUnitMappings;
    return this;
  }

  @Override
  public BatchCreateAdUnitMappingsResponse set(String fieldName, Object value) {
    return (BatchCreateAdUnitMappingsResponse) super.set(fieldName, value);
  }

  @Override
  public BatchCreateAdUnitMappingsResponse clone() {
    return (BatchCreateAdUnitMappingsResponse) super.clone();
  }

}
