/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * The specification for generating a Campaign report. For example, the specification to get
 * IMPRESSIONS and CLICKS sliced by CAMPAIGN_ID can look like the following example: { "date_range":
 * { "start_date": {"year": 2021, "month": 12, "day": 1}, "end_date": {"year": 2021, "month": 12,
 * "day": 30} }, "dimensions": ["CAMPAIGN_ID"], "metrics": ["IMPRESSIONS", "CLICKS"], }
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CampaignReportSpec extends com.google.api.client.json.GenericJson {

  /**
   * The date range for which the report is generated. The max range is 30 days.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateRange dateRange;

  /**
   * List of dimensions of the report. The value combination of these dimensions determines the row
   * of the report. If no dimensions are specified, the report returns a single row of requested
   * metrics for the entire account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dimensions;

  /**
   * Language used for any localized text, such as certain applicable dimension values. The language
   * tag is defined in the IETF BCP47. Defaults to 'en-US' if unspecified or invalid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * List of metrics of the report. A report must specify at least one metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> metrics;

  /**
   * The date range for which the report is generated. The max range is 30 days.
   * @return value or {@code null} for none
   */
  public DateRange getDateRange() {
    return dateRange;
  }

  /**
   * The date range for which the report is generated. The max range is 30 days.
   * @param dateRange dateRange or {@code null} for none
   */
  public CampaignReportSpec setDateRange(DateRange dateRange) {
    this.dateRange = dateRange;
    return this;
  }

  /**
   * List of dimensions of the report. The value combination of these dimensions determines the row
   * of the report. If no dimensions are specified, the report returns a single row of requested
   * metrics for the entire account.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDimensions() {
    return dimensions;
  }

  /**
   * List of dimensions of the report. The value combination of these dimensions determines the row
   * of the report. If no dimensions are specified, the report returns a single row of requested
   * metrics for the entire account.
   * @param dimensions dimensions or {@code null} for none
   */
  public CampaignReportSpec setDimensions(java.util.List<java.lang.String> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Language used for any localized text, such as certain applicable dimension values. The language
   * tag is defined in the IETF BCP47. Defaults to 'en-US' if unspecified or invalid.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Language used for any localized text, such as certain applicable dimension values. The language
   * tag is defined in the IETF BCP47. Defaults to 'en-US' if unspecified or invalid.
   * @param languageCode languageCode or {@code null} for none
   */
  public CampaignReportSpec setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * List of metrics of the report. A report must specify at least one metric.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMetrics() {
    return metrics;
  }

  /**
   * List of metrics of the report. A report must specify at least one metric.
   * @param metrics metrics or {@code null} for none
   */
  public CampaignReportSpec setMetrics(java.util.List<java.lang.String> metrics) {
    this.metrics = metrics;
    return this;
  }

  @Override
  public CampaignReportSpec set(String fieldName, Object value) {
    return (CampaignReportSpec) super.set(fieldName, value);
  }

  @Override
  public CampaignReportSpec clone() {
    return (CampaignReportSpec) super.clone();
  }

}
