/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Response for the ListAdUnitMappingsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAdUnitMappingsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ad unit mappings from the specified account and ad unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdUnitMapping> adUnitMappings;

  static {
    // hack to force ProGuard to consider AdUnitMapping used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AdUnitMapping.class);
  }

  /**
   * Used to set the `page_token` in the `ListAdUnitMappingsRequest` to retrieve the next page. If
   * this field is omitted, there are no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The ad unit mappings from the specified account and ad unit.
   * @return value or {@code null} for none
   */
  public java.util.List<AdUnitMapping> getAdUnitMappings() {
    return adUnitMappings;
  }

  /**
   * The ad unit mappings from the specified account and ad unit.
   * @param adUnitMappings adUnitMappings or {@code null} for none
   */
  public ListAdUnitMappingsResponse setAdUnitMappings(java.util.List<AdUnitMapping> adUnitMappings) {
    this.adUnitMappings = adUnitMappings;
    return this;
  }

  /**
   * Used to set the `page_token` in the `ListAdUnitMappingsRequest` to retrieve the next page. If
   * this field is omitted, there are no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Used to set the `page_token` in the `ListAdUnitMappingsRequest` to retrieve the next page. If
   * this field is omitted, there are no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAdUnitMappingsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAdUnitMappingsResponse set(String fieldName, Object value) {
    return (ListAdUnitMappingsResponse) super.set(fieldName, value);
  }

  @Override
  public ListAdUnitMappingsResponse clone() {
    return (ListAdUnitMappingsResponse) super.clone();
  }

}
