/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Describes an AdMob mediation group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediationGroup extends com.google.api.client.json.GenericJson {

  /**
   * User provided name for the mediation group. The maximum length allowed is 120 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. The state of the mediation a/b experiment that belongs to this mediation group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediationAbExperimentState;

  /**
   * The ID of the mediation group. Example: "0123456789". This is a read only property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediationGroupId;

  /**
   * The mediation lines used for serving for this mediation group. Key is the ID of the mediation
   * group line. For creation, use distinct negative values as placeholder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, MediationGroupMediationGroupLine> mediationGroupLines;

  /**
   * Resource name for this mediation group. Format is:
   * accounts/{publisher_id}/mediationGroups/{mediation_group_id} Example:
   * accounts/pub-9876543210987654/mediationGroups/0123456789
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The status of the mediation group. Only enabled mediation groups will be served.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Set of criteria targeted by this mediation group, such as ad units and geo locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediationGroupTargeting targeting;

  /**
   * User provided name for the mediation group. The maximum length allowed is 120 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * User provided name for the mediation group. The maximum length allowed is 120 characters.
   * @param displayName displayName or {@code null} for none
   */
  public MediationGroup setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. The state of the mediation a/b experiment that belongs to this mediation group.
   * @return value or {@code null} for none
   */
  public java.lang.String getMediationAbExperimentState() {
    return mediationAbExperimentState;
  }

  /**
   * Output only. The state of the mediation a/b experiment that belongs to this mediation group.
   * @param mediationAbExperimentState mediationAbExperimentState or {@code null} for none
   */
  public MediationGroup setMediationAbExperimentState(java.lang.String mediationAbExperimentState) {
    this.mediationAbExperimentState = mediationAbExperimentState;
    return this;
  }

  /**
   * The ID of the mediation group. Example: "0123456789". This is a read only property.
   * @return value or {@code null} for none
   */
  public java.lang.String getMediationGroupId() {
    return mediationGroupId;
  }

  /**
   * The ID of the mediation group. Example: "0123456789". This is a read only property.
   * @param mediationGroupId mediationGroupId or {@code null} for none
   */
  public MediationGroup setMediationGroupId(java.lang.String mediationGroupId) {
    this.mediationGroupId = mediationGroupId;
    return this;
  }

  /**
   * The mediation lines used for serving for this mediation group. Key is the ID of the mediation
   * group line. For creation, use distinct negative values as placeholder.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, MediationGroupMediationGroupLine> getMediationGroupLines() {
    return mediationGroupLines;
  }

  /**
   * The mediation lines used for serving for this mediation group. Key is the ID of the mediation
   * group line. For creation, use distinct negative values as placeholder.
   * @param mediationGroupLines mediationGroupLines or {@code null} for none
   */
  public MediationGroup setMediationGroupLines(java.util.Map<String, MediationGroupMediationGroupLine> mediationGroupLines) {
    this.mediationGroupLines = mediationGroupLines;
    return this;
  }

  /**
   * Resource name for this mediation group. Format is:
   * accounts/{publisher_id}/mediationGroups/{mediation_group_id} Example:
   * accounts/pub-9876543210987654/mediationGroups/0123456789
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name for this mediation group. Format is:
   * accounts/{publisher_id}/mediationGroups/{mediation_group_id} Example:
   * accounts/pub-9876543210987654/mediationGroups/0123456789
   * @param name name or {@code null} for none
   */
  public MediationGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The status of the mediation group. Only enabled mediation groups will be served.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The status of the mediation group. Only enabled mediation groups will be served.
   * @param state state or {@code null} for none
   */
  public MediationGroup setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Set of criteria targeted by this mediation group, such as ad units and geo locations.
   * @return value or {@code null} for none
   */
  public MediationGroupTargeting getTargeting() {
    return targeting;
  }

  /**
   * Set of criteria targeted by this mediation group, such as ad units and geo locations.
   * @param targeting targeting or {@code null} for none
   */
  public MediationGroup setTargeting(MediationGroupTargeting targeting) {
    this.targeting = targeting;
    return this;
  }

  @Override
  public MediationGroup set(String fieldName, Object value) {
    return (MediationGroup) super.set(fieldName, value);
  }

  @Override
  public MediationGroup clone() {
    return (MediationGroup) super.clone();
  }

}
