/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Set of criteria targeted by this mediation group. For example, a mediation group can target
 * specific ad unit IDs, platform, format and geo location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediationGroupTargeting extends com.google.api.client.json.GenericJson {

  /**
   * Ad units targeted by this mediation group. Example: "ca-app-pub-1234/8790".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> adUnitIds;

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group does not exclude any region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> excludedRegionCodes;

  /**
   * Ad format targeted by this mediation group. Examples: "banner", "native".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * The parameter can be used to target ad requests based on the availability of the IDFA. If set
   * to ALL, the mediation group applies to all ad requests (with or without IDFA). If set to
   * AVAILABLE, the mediation group applies to ad requests with IDFA. If set to NOT_AVAILABLE, the
   * mediation group applies to ad requests without IDFA. Doesn't need to be specified for an
   * ANDROID device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idfaTargeting;

  /**
   * Describes the platform of the app. Examples: "IOS", "Android".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group targets all available regions. For more information, see
   * http://www.unicode.org/reports/tr35/#unicode_region_subtag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetedRegionCodes;

  /**
   * Ad units targeted by this mediation group. Example: "ca-app-pub-1234/8790".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdUnitIds() {
    return adUnitIds;
  }

  /**
   * Ad units targeted by this mediation group. Example: "ca-app-pub-1234/8790".
   * @param adUnitIds adUnitIds or {@code null} for none
   */
  public MediationGroupTargeting setAdUnitIds(java.util.List<java.lang.String> adUnitIds) {
    this.adUnitIds = adUnitIds;
    return this;
  }

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group does not exclude any region.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExcludedRegionCodes() {
    return excludedRegionCodes;
  }

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group does not exclude any region.
   * @param excludedRegionCodes excludedRegionCodes or {@code null} for none
   */
  public MediationGroupTargeting setExcludedRegionCodes(java.util.List<java.lang.String> excludedRegionCodes) {
    this.excludedRegionCodes = excludedRegionCodes;
    return this;
  }

  /**
   * Ad format targeted by this mediation group. Examples: "banner", "native".
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * Ad format targeted by this mediation group. Examples: "banner", "native".
   * @param format format or {@code null} for none
   */
  public MediationGroupTargeting setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * The parameter can be used to target ad requests based on the availability of the IDFA. If set
   * to ALL, the mediation group applies to all ad requests (with or without IDFA). If set to
   * AVAILABLE, the mediation group applies to ad requests with IDFA. If set to NOT_AVAILABLE, the
   * mediation group applies to ad requests without IDFA. Doesn't need to be specified for an
   * ANDROID device.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdfaTargeting() {
    return idfaTargeting;
  }

  /**
   * The parameter can be used to target ad requests based on the availability of the IDFA. If set
   * to ALL, the mediation group applies to all ad requests (with or without IDFA). If set to
   * AVAILABLE, the mediation group applies to ad requests with IDFA. If set to NOT_AVAILABLE, the
   * mediation group applies to ad requests without IDFA. Doesn't need to be specified for an
   * ANDROID device.
   * @param idfaTargeting idfaTargeting or {@code null} for none
   */
  public MediationGroupTargeting setIdfaTargeting(java.lang.String idfaTargeting) {
    this.idfaTargeting = idfaTargeting;
    return this;
  }

  /**
   * Describes the platform of the app. Examples: "IOS", "Android".
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * Describes the platform of the app. Examples: "IOS", "Android".
   * @param platform platform or {@code null} for none
   */
  public MediationGroupTargeting setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group targets all available regions. For more information, see
   * http://www.unicode.org/reports/tr35/#unicode_region_subtag.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetedRegionCodes() {
    return targetedRegionCodes;
  }

  /**
   * The Unicode country/region code (CLDR) of a location, such as "US". Unset if this mediation
   * group targets all available regions. For more information, see
   * http://www.unicode.org/reports/tr35/#unicode_region_subtag.
   * @param targetedRegionCodes targetedRegionCodes or {@code null} for none
   */
  public MediationGroupTargeting setTargetedRegionCodes(java.util.List<java.lang.String> targetedRegionCodes) {
    this.targetedRegionCodes = targetedRegionCodes;
    return this;
  }

  @Override
  public MediationGroupTargeting set(String fieldName, Object value) {
    return (MediationGroupTargeting) super.set(fieldName, value);
  }

  @Override
  public MediationGroupTargeting clone() {
    return (MediationGroupTargeting) super.clone();
  }

}
