/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Response for the ad units list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAdUnitsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The resulting ad units for the requested account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AdUnit> adUnits;

  static {
    // hack to force ProGuard to consider AdUnit used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AdUnit.class);
  }

  /**
   * If not empty, indicates that there may be more ad units for the request; this value should be
   * passed in a new `ListAdUnitsRequest`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The resulting ad units for the requested account.
   * @return value or {@code null} for none
   */
  public java.util.List<AdUnit> getAdUnits() {
    return adUnits;
  }

  /**
   * The resulting ad units for the requested account.
   * @param adUnits adUnits or {@code null} for none
   */
  public ListAdUnitsResponse setAdUnits(java.util.List<AdUnit> adUnits) {
    this.adUnits = adUnits;
    return this;
  }

  /**
   * If not empty, indicates that there may be more ad units for the request; this value should be
   * passed in a new `ListAdUnitsRequest`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more ad units for the request; this value should be
   * passed in a new `ListAdUnitsRequest`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAdUnitsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListAdUnitsResponse set(String fieldName, Object value) {
    return (ListAdUnitsResponse) super.set(fieldName, value);
  }

  @Override
  public ListAdUnitsResponse clone() {
    return (ListAdUnitsResponse) super.clone();
  }

}
