/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Response for the mediation groups list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMediationGroupsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The resulting mediation groups for the requested account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MediationGroup> mediationGroups;

  /**
   * If not empty, indicates that there may be more mediation groups for the request; this value
   * should be passed in a new `ListMediationGroupsRequest`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The resulting mediation groups for the requested account.
   * @return value or {@code null} for none
   */
  public java.util.List<MediationGroup> getMediationGroups() {
    return mediationGroups;
  }

  /**
   * The resulting mediation groups for the requested account.
   * @param mediationGroups mediationGroups or {@code null} for none
   */
  public ListMediationGroupsResponse setMediationGroups(java.util.List<MediationGroup> mediationGroups) {
    this.mediationGroups = mediationGroups;
    return this;
  }

  /**
   * If not empty, indicates that there may be more mediation groups for the request; this value
   * should be passed in a new `ListMediationGroupsRequest`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more mediation groups for the request; this value
   * should be passed in a new `ListMediationGroupsRequest`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMediationGroupsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListMediationGroupsResponse set(String fieldName, Object value) {
    return (ListMediationGroupsResponse) super.set(fieldName, value);
  }

  @Override
  public ListMediationGroupsResponse clone() {
    return (ListMediationGroupsResponse) super.clone();
  }

}
