/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admob.v1beta;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admob.v1beta.AdMobRequest;
import com.google.api.services.admob.v1beta.AdMobRequestInitializer;
import com.google.api.services.admob.v1beta.model.AdUnit;
import com.google.api.services.admob.v1beta.model.AdUnitMapping;
import com.google.api.services.admob.v1beta.model.App;
import com.google.api.services.admob.v1beta.model.BatchCreateAdUnitMappingsRequest;
import com.google.api.services.admob.v1beta.model.BatchCreateAdUnitMappingsResponse;
import com.google.api.services.admob.v1beta.model.GenerateCampaignReportRequest;
import com.google.api.services.admob.v1beta.model.GenerateCampaignReportResponse;
import com.google.api.services.admob.v1beta.model.GenerateMediationReportRequest;
import com.google.api.services.admob.v1beta.model.GenerateMediationReportResponse;
import com.google.api.services.admob.v1beta.model.GenerateNetworkReportRequest;
import com.google.api.services.admob.v1beta.model.GenerateNetworkReportResponse;
import com.google.api.services.admob.v1beta.model.ListAdSourcesResponse;
import com.google.api.services.admob.v1beta.model.ListAdUnitMappingsResponse;
import com.google.api.services.admob.v1beta.model.ListAdUnitsResponse;
import com.google.api.services.admob.v1beta.model.ListAdaptersResponse;
import com.google.api.services.admob.v1beta.model.ListAppsResponse;
import com.google.api.services.admob.v1beta.model.ListMediationGroupsResponse;
import com.google.api.services.admob.v1beta.model.ListPublisherAccountsResponse;
import com.google.api.services.admob.v1beta.model.MediationAbExperiment;
import com.google.api.services.admob.v1beta.model.MediationGroup;
import com.google.api.services.admob.v1beta.model.PublisherAccount;
import com.google.api.services.admob.v1beta.model.StopMediationAbExperimentRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class AdMob
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://admob.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://admob.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://admob.googleapis.com/";

    public AdMob(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AdMob(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the AdMob API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AdMob.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://admob.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AdMob.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AdMob.DEFAULT_BATCH_PATH);
        }

        public AdMob build() {
            return new AdMob(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAdMobRequestInitializer(AdMobRequestInitializer admobRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)admobRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Accounts {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AdSources adSources() {
            return new AdSources();
        }

        public AdUnitMappings adUnitMappings() {
            return new AdUnitMappings();
        }

        public AdUnits adUnits() {
            return new AdUnits();
        }

        public Apps apps() {
            return new Apps();
        }

        public CampaignReport campaignReport() {
            return new CampaignReport();
        }

        public MediationGroups mediationGroups() {
            return new MediationGroups();
        }

        public MediationReport mediationReport() {
            return new MediationReport();
        }

        public NetworkReport networkReport() {
            return new NetworkReport();
        }

        public class NetworkReport {
            public Generate generate(String parent, GenerateNetworkReportRequest content) throws IOException {
                Generate result = new Generate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Generate
            extends AdMobRequest<GenerateNetworkReportResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/networkReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String parent, GenerateNetworkReportRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, GenerateNetworkReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String $Xgafv) {
                    return (Generate)super.set$Xgafv($Xgafv);
                }

                public Generate setAccessToken(String accessToken) {
                    return (Generate)super.setAccessToken(accessToken);
                }

                public Generate setAlt(String alt) {
                    return (Generate)super.setAlt(alt);
                }

                public Generate setCallback(String callback) {
                    return (Generate)super.setCallback(callback);
                }

                public Generate setFields(String fields) {
                    return (Generate)super.setFields(fields);
                }

                public Generate setKey(String key) {
                    return (Generate)super.setKey(key);
                }

                public Generate setOauthToken(String oauthToken) {
                    return (Generate)super.setOauthToken(oauthToken);
                }

                public Generate setPrettyPrint(Boolean prettyPrint) {
                    return (Generate)super.setPrettyPrint(prettyPrint);
                }

                public Generate setQuotaUser(String quotaUser) {
                    return (Generate)super.setQuotaUser(quotaUser);
                }

                public Generate setUploadType(String uploadType) {
                    return (Generate)super.setUploadType(uploadType);
                }

                public Generate setUploadProtocol(String uploadProtocol) {
                    return (Generate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Generate set(String parameterName, Object value) {
                    return (Generate)super.set(parameterName, value);
                }
            }
        }

        public class MediationReport {
            public Generate generate(String parent, GenerateMediationReportRequest content) throws IOException {
                Generate result = new Generate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Generate
            extends AdMobRequest<GenerateMediationReportResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/mediationReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String parent, GenerateMediationReportRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, GenerateMediationReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String $Xgafv) {
                    return (Generate)super.set$Xgafv($Xgafv);
                }

                public Generate setAccessToken(String accessToken) {
                    return (Generate)super.setAccessToken(accessToken);
                }

                public Generate setAlt(String alt) {
                    return (Generate)super.setAlt(alt);
                }

                public Generate setCallback(String callback) {
                    return (Generate)super.setCallback(callback);
                }

                public Generate setFields(String fields) {
                    return (Generate)super.setFields(fields);
                }

                public Generate setKey(String key) {
                    return (Generate)super.setKey(key);
                }

                public Generate setOauthToken(String oauthToken) {
                    return (Generate)super.setOauthToken(oauthToken);
                }

                public Generate setPrettyPrint(Boolean prettyPrint) {
                    return (Generate)super.setPrettyPrint(prettyPrint);
                }

                public Generate setQuotaUser(String quotaUser) {
                    return (Generate)super.setQuotaUser(quotaUser);
                }

                public Generate setUploadType(String uploadType) {
                    return (Generate)super.setUploadType(uploadType);
                }

                public Generate setUploadProtocol(String uploadProtocol) {
                    return (Generate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Generate set(String parameterName, Object value) {
                    return (Generate)super.set(parameterName, value);
                }
            }
        }

        public class MediationGroups {
            public Create create(String parent, MediationGroup content) throws IOException {
                Create result = new Create(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, MediationGroup content) throws IOException {
                Patch result = new Patch(name, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public MediationAbExperiments mediationAbExperiments() {
                return new MediationAbExperiments();
            }

            public class MediationAbExperiments {
                public Create create(String parent, MediationAbExperiment content) throws IOException {
                    Create result = new Create(parent, content);
                    AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Stop stop(String name, StopMediationAbExperimentRequest content) throws IOException {
                    Stop result = new Stop(name, content);
                    AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Stop
                extends AdMobRequest<MediationAbExperiment> {
                    private static final String REST_PATH = "v1beta/{+name}:stop";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Stop(String name, StopMediationAbExperimentRequest content) {
                        super(AdMob.this, "POST", REST_PATH, (Object)content, MediationAbExperiment.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/mediationGroups/[^/]+/mediationAbExperiments$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+/mediationAbExperiments$");
                        }
                    }

                    public Stop set$Xgafv(String $Xgafv) {
                        return (Stop)super.set$Xgafv($Xgafv);
                    }

                    public Stop setAccessToken(String accessToken) {
                        return (Stop)super.setAccessToken(accessToken);
                    }

                    public Stop setAlt(String alt) {
                        return (Stop)super.setAlt(alt);
                    }

                    public Stop setCallback(String callback) {
                        return (Stop)super.setCallback(callback);
                    }

                    public Stop setFields(String fields) {
                        return (Stop)super.setFields(fields);
                    }

                    public Stop setKey(String key) {
                        return (Stop)super.setKey(key);
                    }

                    public Stop setOauthToken(String oauthToken) {
                        return (Stop)super.setOauthToken(oauthToken);
                    }

                    public Stop setPrettyPrint(Boolean prettyPrint) {
                        return (Stop)super.setPrettyPrint(prettyPrint);
                    }

                    public Stop setQuotaUser(String quotaUser) {
                        return (Stop)super.setQuotaUser(quotaUser);
                    }

                    public Stop setUploadType(String uploadType) {
                        return (Stop)super.setUploadType(uploadType);
                    }

                    public Stop setUploadProtocol(String uploadProtocol) {
                        return (Stop)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Stop setName(String name) {
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+/mediationAbExperiments$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Stop set(String parameterName, Object value) {
                        return (Stop)super.set(parameterName, value);
                    }
                }

                public class Create
                extends AdMobRequest<MediationAbExperiment> {
                    private static final String REST_PATH = "v1beta/{+parent}/mediationAbExperiments";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, MediationAbExperiment content) {
                        super(AdMob.this, "POST", REST_PATH, (Object)content, MediationAbExperiment.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/mediationGroups/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Patch
            extends AdMobRequest<MediationGroup> {
                private static final String REST_PATH = "v1beta/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, MediationGroup content) {
                    super(AdMob.this, "PATCH", REST_PATH, (Object)content, MediationGroup.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/mediationGroups/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/mediationGroups/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AdMobRequest<ListMediationGroupsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/mediationGroups";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListMediationGroupsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdMobRequest<MediationGroup> {
                private static final String REST_PATH = "v1beta/{+parent}/mediationGroups";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, MediationGroup content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, MediationGroup.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class CampaignReport {
            public Generate generate(String parent, GenerateCampaignReportRequest content) throws IOException {
                Generate result = new Generate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Generate
            extends AdMobRequest<GenerateCampaignReportResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/campaignReport:generate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Generate(String parent, GenerateCampaignReportRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, GenerateCampaignReportResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Generate set$Xgafv(String $Xgafv) {
                    return (Generate)super.set$Xgafv($Xgafv);
                }

                public Generate setAccessToken(String accessToken) {
                    return (Generate)super.setAccessToken(accessToken);
                }

                public Generate setAlt(String alt) {
                    return (Generate)super.setAlt(alt);
                }

                public Generate setCallback(String callback) {
                    return (Generate)super.setCallback(callback);
                }

                public Generate setFields(String fields) {
                    return (Generate)super.setFields(fields);
                }

                public Generate setKey(String key) {
                    return (Generate)super.setKey(key);
                }

                public Generate setOauthToken(String oauthToken) {
                    return (Generate)super.setOauthToken(oauthToken);
                }

                public Generate setPrettyPrint(Boolean prettyPrint) {
                    return (Generate)super.setPrettyPrint(prettyPrint);
                }

                public Generate setQuotaUser(String quotaUser) {
                    return (Generate)super.setQuotaUser(quotaUser);
                }

                public Generate setUploadType(String uploadType) {
                    return (Generate)super.setUploadType(uploadType);
                }

                public Generate setUploadProtocol(String uploadProtocol) {
                    return (Generate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Generate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Generate set(String parameterName, Object value) {
                    return (Generate)super.set(parameterName, value);
                }
            }
        }

        public class Apps {
            public Create create(String parent, App content) throws IOException {
                Create result = new Create(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AdMobRequest<ListAppsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/apps";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListAppsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdMobRequest<App> {
                private static final String REST_PATH = "v1beta/{+parent}/apps";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, App content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, App.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class AdUnits {
            public Create create(String parent, AdUnit content) throws IOException {
                Create result = new Create(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AdUnitMappings adUnitMappings() {
                return new AdUnitMappings();
            }

            public class AdUnitMappings {
                public Create create(String parent, AdUnitMapping content) throws IOException {
                    Create result = new Create(parent, content);
                    AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdMobRequest<ListAdUnitMappingsResponse> {
                    private static final String REST_PATH = "v1beta/{+parent}/adUnitMappings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(AdMob.this, "GET", REST_PATH, null, ListAdUnitMappingsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/adUnits/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adUnits/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adUnits/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Create
                extends AdMobRequest<AdUnitMapping> {
                    private static final String REST_PATH = "v1beta/{+parent}/adUnitMappings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, AdUnitMapping content) {
                        super(AdMob.this, "POST", REST_PATH, (Object)content, AdUnitMapping.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/adUnits/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adUnits/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adUnits/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends AdMobRequest<ListAdUnitsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/adUnits";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListAdUnitsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Create
            extends AdMobRequest<AdUnit> {
                private static final String REST_PATH = "v1beta/{+parent}/adUnits";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, AdUnit content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, AdUnit.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class AdUnitMappings {
            public BatchCreate batchCreate(String parent, BatchCreateAdUnitMappingsRequest content) throws IOException {
                BatchCreate result = new BatchCreate(parent, content);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class BatchCreate
            extends AdMobRequest<BatchCreateAdUnitMappingsResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/adUnitMappings:batchCreate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchCreate(String parent, BatchCreateAdUnitMappingsRequest content) {
                    super(AdMob.this, "POST", REST_PATH, (Object)content, BatchCreateAdUnitMappingsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public BatchCreate set$Xgafv(String $Xgafv) {
                    return (BatchCreate)super.set$Xgafv($Xgafv);
                }

                public BatchCreate setAccessToken(String accessToken) {
                    return (BatchCreate)super.setAccessToken(accessToken);
                }

                public BatchCreate setAlt(String alt) {
                    return (BatchCreate)super.setAlt(alt);
                }

                public BatchCreate setCallback(String callback) {
                    return (BatchCreate)super.setCallback(callback);
                }

                public BatchCreate setFields(String fields) {
                    return (BatchCreate)super.setFields(fields);
                }

                public BatchCreate setKey(String key) {
                    return (BatchCreate)super.setKey(key);
                }

                public BatchCreate setOauthToken(String oauthToken) {
                    return (BatchCreate)super.setOauthToken(oauthToken);
                }

                public BatchCreate setPrettyPrint(Boolean prettyPrint) {
                    return (BatchCreate)super.setPrettyPrint(prettyPrint);
                }

                public BatchCreate setQuotaUser(String quotaUser) {
                    return (BatchCreate)super.setQuotaUser(quotaUser);
                }

                public BatchCreate setUploadType(String uploadType) {
                    return (BatchCreate)super.setUploadType(uploadType);
                }

                public BatchCreate setUploadProtocol(String uploadProtocol) {
                    return (BatchCreate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchCreate setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public BatchCreate set(String parameterName, Object value) {
                    return (BatchCreate)super.set(parameterName, value);
                }
            }
        }

        public class AdSources {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Adapters adapters() {
                return new Adapters();
            }

            public class Adapters {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    AdMob.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AdMobRequest<ListAdaptersResponse> {
                    private static final String REST_PATH = "v1beta/{+parent}/adapters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(AdMob.this, "GET", REST_PATH, null, ListAdaptersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/adSources/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adSources/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!AdMob.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/adSources/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends AdMobRequest<ListAdSourcesResponse> {
                private static final String REST_PATH = "v1beta/{+parent}/adSources";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(AdMob.this, "GET", REST_PATH, null, ListAdSourcesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!AdMob.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends AdMobRequest<ListPublisherAccountsResponse> {
            private static final String REST_PATH = "v1beta/accounts";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(AdMob.this, "GET", REST_PATH, null, ListPublisherAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends AdMobRequest<PublisherAccount> {
            private static final String REST_PATH = "v1beta/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(AdMob.this, "GET", REST_PATH, null, PublisherAccount.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!AdMob.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

