/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Configuration metadata associated with this adapter. They are used to define the
 * ad_unit_configurations associated with AdUnitMappings for the this adapter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdapterAdapterConfigMetadata extends com.google.api.client.json.GenericJson {

  /**
   * This is used to fill the key of the
   * [ad_unit_configurations](#AdUnitMapping.ad_unit_configurations).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adapterConfigMetadataId;

  /**
   * Name of the adapter configuration metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adapterConfigMetadataLabel;

  /**
   * Whether this metadata is required for configuring the AdUnitMappings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRequired;

  /**
   * This is used to fill the key of the
   * [ad_unit_configurations](#AdUnitMapping.ad_unit_configurations).
   * @return value or {@code null} for none
   */
  public java.lang.String getAdapterConfigMetadataId() {
    return adapterConfigMetadataId;
  }

  /**
   * This is used to fill the key of the
   * [ad_unit_configurations](#AdUnitMapping.ad_unit_configurations).
   * @param adapterConfigMetadataId adapterConfigMetadataId or {@code null} for none
   */
  public AdapterAdapterConfigMetadata setAdapterConfigMetadataId(java.lang.String adapterConfigMetadataId) {
    this.adapterConfigMetadataId = adapterConfigMetadataId;
    return this;
  }

  /**
   * Name of the adapter configuration metadata.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdapterConfigMetadataLabel() {
    return adapterConfigMetadataLabel;
  }

  /**
   * Name of the adapter configuration metadata.
   * @param adapterConfigMetadataLabel adapterConfigMetadataLabel or {@code null} for none
   */
  public AdapterAdapterConfigMetadata setAdapterConfigMetadataLabel(java.lang.String adapterConfigMetadataLabel) {
    this.adapterConfigMetadataLabel = adapterConfigMetadataLabel;
    return this;
  }

  /**
   * Whether this metadata is required for configuring the AdUnitMappings.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRequired() {
    return isRequired;
  }

  /**
   * Whether this metadata is required for configuring the AdUnitMappings.
   * @param isRequired isRequired or {@code null} for none
   */
  public AdapterAdapterConfigMetadata setIsRequired(java.lang.Boolean isRequired) {
    this.isRequired = isRequired;
    return this;
  }

  @Override
  public AdapterAdapterConfigMetadata set(String fieldName, Object value) {
    return (AdapterAdapterConfigMetadata) super.set(fieldName, value);
  }

  @Override
  public AdapterAdapterConfigMetadata clone() {
    return (AdapterAdapterConfigMetadata) super.clone();
  }

}
