/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Information from the app store if the app is linked to an app store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppLinkedAppInfo extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The app store information for published Android apps. This field is only used for
   * apps on the Android platform and will be ignored if the PLATFORM is set to iOS. The default
   * value is the Google Play App store. This field can be updated after app is created. If the app
   * is not published, this field will not be included in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> androidAppStores;

  /**
   * The app store ID of the app; present if and only if the app is linked to an app store. If the
   * app is added to the Google Play store, it will be the application ID of the app. For example:
   * "com.example.myapp". See https://developer.android.com/studio/build/application-id. If the app
   * is added to the Apple App Store, it will be app store ID. For example "105169111". Note that
   * setting the app store id is considered an irreversible action. Once an app is linked, it cannot
   * be unlinked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appStoreId;

  /**
   * Output only. Display name of the app as it appears in the app store. This is an output-only
   * field, and may be empty if the app cannot be found in the store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Optional. The app store information for published Android apps. This field is only used for
   * apps on the Android platform and will be ignored if the PLATFORM is set to iOS. The default
   * value is the Google Play App store. This field can be updated after app is created. If the app
   * is not published, this field will not be included in the response.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAndroidAppStores() {
    return androidAppStores;
  }

  /**
   * Optional. The app store information for published Android apps. This field is only used for
   * apps on the Android platform and will be ignored if the PLATFORM is set to iOS. The default
   * value is the Google Play App store. This field can be updated after app is created. If the app
   * is not published, this field will not be included in the response.
   * @param androidAppStores androidAppStores or {@code null} for none
   */
  public AppLinkedAppInfo setAndroidAppStores(java.util.List<java.lang.String> androidAppStores) {
    this.androidAppStores = androidAppStores;
    return this;
  }

  /**
   * The app store ID of the app; present if and only if the app is linked to an app store. If the
   * app is added to the Google Play store, it will be the application ID of the app. For example:
   * "com.example.myapp". See https://developer.android.com/studio/build/application-id. If the app
   * is added to the Apple App Store, it will be app store ID. For example "105169111". Note that
   * setting the app store id is considered an irreversible action. Once an app is linked, it cannot
   * be unlinked.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppStoreId() {
    return appStoreId;
  }

  /**
   * The app store ID of the app; present if and only if the app is linked to an app store. If the
   * app is added to the Google Play store, it will be the application ID of the app. For example:
   * "com.example.myapp". See https://developer.android.com/studio/build/application-id. If the app
   * is added to the Apple App Store, it will be app store ID. For example "105169111". Note that
   * setting the app store id is considered an irreversible action. Once an app is linked, it cannot
   * be unlinked.
   * @param appStoreId appStoreId or {@code null} for none
   */
  public AppLinkedAppInfo setAppStoreId(java.lang.String appStoreId) {
    this.appStoreId = appStoreId;
    return this;
  }

  /**
   * Output only. Display name of the app as it appears in the app store. This is an output-only
   * field, and may be empty if the app cannot be found in the store.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Output only. Display name of the app as it appears in the app store. This is an output-only
   * field, and may be empty if the app cannot be found in the store.
   * @param displayName displayName or {@code null} for none
   */
  public AppLinkedAppInfo setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  @Override
  public AppLinkedAppInfo set(String fieldName, Object value) {
    return (AppLinkedAppInfo) super.set(fieldName, value);
  }

  @Override
  public AppLinkedAppInfo clone() {
    return (AppLinkedAppInfo) super.clone();
  }

}
