/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Request to create an ad unit mapping under the specific AdMob account and ad unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateAdUnitMappingRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The ad unit mapping to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AdUnitMapping adUnitMapping;

  /**
   * Required. The parent which owns the ad unit mapping. Format:
   * accounts/{publisher_id}/adUnits/{ad_unit_id}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parent;

  /**
   * Required. The ad unit mapping to create.
   * @return value or {@code null} for none
   */
  public AdUnitMapping getAdUnitMapping() {
    return adUnitMapping;
  }

  /**
   * Required. The ad unit mapping to create.
   * @param adUnitMapping adUnitMapping or {@code null} for none
   */
  public CreateAdUnitMappingRequest setAdUnitMapping(AdUnitMapping adUnitMapping) {
    this.adUnitMapping = adUnitMapping;
    return this;
  }

  /**
   * Required. The parent which owns the ad unit mapping. Format:
   * accounts/{publisher_id}/adUnits/{ad_unit_id}
   * @return value or {@code null} for none
   */
  public java.lang.String getParent() {
    return parent;
  }

  /**
   * Required. The parent which owns the ad unit mapping. Format:
   * accounts/{publisher_id}/adUnits/{ad_unit_id}
   * @param parent parent or {@code null} for none
   */
  public CreateAdUnitMappingRequest setParent(java.lang.String parent) {
    this.parent = parent;
    return this;
  }

  @Override
  public CreateAdUnitMappingRequest set(String fieldName, Object value) {
    return (CreateAdUnitMappingRequest) super.set(fieldName, value);
  }

  @Override
  public CreateAdUnitMappingRequest clone() {
    return (CreateAdUnitMappingRequest) super.clone();
  }

}
