/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Response for the publisher account list request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListPublisherAccountsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Publisher that the client credentials can access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PublisherAccount> account;

  /**
   * If not empty, indicates that there might be more accounts for the request; you must pass this
   * value in a new `ListPublisherAccountsRequest`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Publisher that the client credentials can access.
   * @return value or {@code null} for none
   */
  public java.util.List<PublisherAccount> getAccount() {
    return account;
  }

  /**
   * Publisher that the client credentials can access.
   * @param account account or {@code null} for none
   */
  public ListPublisherAccountsResponse setAccount(java.util.List<PublisherAccount> account) {
    this.account = account;
    return this;
  }

  /**
   * If not empty, indicates that there might be more accounts for the request; you must pass this
   * value in a new `ListPublisherAccountsRequest`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there might be more accounts for the request; you must pass this
   * value in a new `ListPublisherAccountsRequest`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListPublisherAccountsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListPublisherAccountsResponse set(String fieldName, Object value) {
    return (ListPublisherAccountsResponse) super.set(fieldName, value);
  }

  @Override
  public ListPublisherAccountsResponse clone() {
    return (ListPublisherAccountsResponse) super.clone();
  }

}
