/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * The mediation A/B experiment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediationAbExperiment extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The experiment mediation lines for control. They are inherited from the parent
   * mediation group. It is an output only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MediationAbExperimentExperimentMediationLine> controlMediationLines;

  /**
   * The display name for the mediation A/B experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. The time at which the experiment was ended or target to end (in UTC).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Output only. Unique identifier for the mediation A/B experiment. It is an output only property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String experimentId;

  /**
   * Output only. The mediation group id this experiment belongs to. This can be used for filtering
   * the experiments in the list experiments API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediationGroupId;

  /**
   * Resource name for this experiment. The format is accounts/{publisher_id}/
   * mediationGroups/{mediation_group_id}/mediationAbExperiment/ {mediation_group_experiment_id}.
   * For example: accounts/pub-9876543210987654/mediationGroups/0123456789/
   * mediationAbExperiment/12345
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The time at which the experiment was started (in UTC).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Output only. The state of the experiment. It is an output only field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The experiment mediation lines created for the treatment. They will be used for serving when
   * the experiment status is RUNNING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MediationAbExperimentExperimentMediationLine> treatmentMediationLines;

  /**
   * The percentage of the mediation A/B experiment traffic that will be send to the treatment
   * (variant B). The remainder is sent to the control (variant A). The percentage is expressed as
   * an integer in the inclusive range of [1,99]. See
   * https://support.google.com/admob/answer/9572326 for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long treatmentTrafficPercentage;

  /**
   * Output only. The variant leader for the experiment according to some key metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String variantLeader;

  /**
   * Output only. The experiment mediation lines for control. They are inherited from the parent
   * mediation group. It is an output only field.
   * @return value or {@code null} for none
   */
  public java.util.List<MediationAbExperimentExperimentMediationLine> getControlMediationLines() {
    return controlMediationLines;
  }

  /**
   * Output only. The experiment mediation lines for control. They are inherited from the parent
   * mediation group. It is an output only field.
   * @param controlMediationLines controlMediationLines or {@code null} for none
   */
  public MediationAbExperiment setControlMediationLines(java.util.List<MediationAbExperimentExperimentMediationLine> controlMediationLines) {
    this.controlMediationLines = controlMediationLines;
    return this;
  }

  /**
   * The display name for the mediation A/B experiment.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The display name for the mediation A/B experiment.
   * @param displayName displayName or {@code null} for none
   */
  public MediationAbExperiment setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. The time at which the experiment was ended or target to end (in UTC).
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * Output only. The time at which the experiment was ended or target to end (in UTC).
   * @param endTime endTime or {@code null} for none
   */
  public MediationAbExperiment setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Output only. Unique identifier for the mediation A/B experiment. It is an output only property.
   * @return value or {@code null} for none
   */
  public java.lang.String getExperimentId() {
    return experimentId;
  }

  /**
   * Output only. Unique identifier for the mediation A/B experiment. It is an output only property.
   * @param experimentId experimentId or {@code null} for none
   */
  public MediationAbExperiment setExperimentId(java.lang.String experimentId) {
    this.experimentId = experimentId;
    return this;
  }

  /**
   * Output only. The mediation group id this experiment belongs to. This can be used for filtering
   * the experiments in the list experiments API.
   * @return value or {@code null} for none
   */
  public java.lang.String getMediationGroupId() {
    return mediationGroupId;
  }

  /**
   * Output only. The mediation group id this experiment belongs to. This can be used for filtering
   * the experiments in the list experiments API.
   * @param mediationGroupId mediationGroupId or {@code null} for none
   */
  public MediationAbExperiment setMediationGroupId(java.lang.String mediationGroupId) {
    this.mediationGroupId = mediationGroupId;
    return this;
  }

  /**
   * Resource name for this experiment. The format is accounts/{publisher_id}/
   * mediationGroups/{mediation_group_id}/mediationAbExperiment/ {mediation_group_experiment_id}.
   * For example: accounts/pub-9876543210987654/mediationGroups/0123456789/
   * mediationAbExperiment/12345
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name for this experiment. The format is accounts/{publisher_id}/
   * mediationGroups/{mediation_group_id}/mediationAbExperiment/ {mediation_group_experiment_id}.
   * For example: accounts/pub-9876543210987654/mediationGroups/0123456789/
   * mediationAbExperiment/12345
   * @param name name or {@code null} for none
   */
  public MediationAbExperiment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The time at which the experiment was started (in UTC).
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Output only. The time at which the experiment was started (in UTC).
   * @param startTime startTime or {@code null} for none
   */
  public MediationAbExperiment setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Output only. The state of the experiment. It is an output only field.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the experiment. It is an output only field.
   * @param state state or {@code null} for none
   */
  public MediationAbExperiment setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * The experiment mediation lines created for the treatment. They will be used for serving when
   * the experiment status is RUNNING.
   * @return value or {@code null} for none
   */
  public java.util.List<MediationAbExperimentExperimentMediationLine> getTreatmentMediationLines() {
    return treatmentMediationLines;
  }

  /**
   * The experiment mediation lines created for the treatment. They will be used for serving when
   * the experiment status is RUNNING.
   * @param treatmentMediationLines treatmentMediationLines or {@code null} for none
   */
  public MediationAbExperiment setTreatmentMediationLines(java.util.List<MediationAbExperimentExperimentMediationLine> treatmentMediationLines) {
    this.treatmentMediationLines = treatmentMediationLines;
    return this;
  }

  /**
   * The percentage of the mediation A/B experiment traffic that will be send to the treatment
   * (variant B). The remainder is sent to the control (variant A). The percentage is expressed as
   * an integer in the inclusive range of [1,99]. See
   * https://support.google.com/admob/answer/9572326 for details.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTreatmentTrafficPercentage() {
    return treatmentTrafficPercentage;
  }

  /**
   * The percentage of the mediation A/B experiment traffic that will be send to the treatment
   * (variant B). The remainder is sent to the control (variant A). The percentage is expressed as
   * an integer in the inclusive range of [1,99]. See
   * https://support.google.com/admob/answer/9572326 for details.
   * @param treatmentTrafficPercentage treatmentTrafficPercentage or {@code null} for none
   */
  public MediationAbExperiment setTreatmentTrafficPercentage(java.lang.Long treatmentTrafficPercentage) {
    this.treatmentTrafficPercentage = treatmentTrafficPercentage;
    return this;
  }

  /**
   * Output only. The variant leader for the experiment according to some key metrics.
   * @return value or {@code null} for none
   */
  public java.lang.String getVariantLeader() {
    return variantLeader;
  }

  /**
   * Output only. The variant leader for the experiment according to some key metrics.
   * @param variantLeader variantLeader or {@code null} for none
   */
  public MediationAbExperiment setVariantLeader(java.lang.String variantLeader) {
    this.variantLeader = variantLeader;
    return this;
  }

  @Override
  public MediationAbExperiment set(String fieldName, Object value) {
    return (MediationAbExperiment) super.set(fieldName, value);
  }

  @Override
  public MediationAbExperiment clone() {
    return (MediationAbExperiment) super.clone();
  }

}
