/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.admob.v1beta.model;

/**
 * Settings for an ad network used by a mediation group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the AdMob API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediationGroupMediationGroupLine extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the ad source this mediation line is associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adSourceId;

  /**
   * References of the ad unit mappings for each ad unit associated with this mediation line. Key is
   * the ad unit ID, value is resource name of the ad unit mapping. For mediation lines where the ad
   * source id is the AdMob Network, ad unit mappings will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> adUnitMappings;

  /**
   * The CPM for this allocation line. $0.01 is the minimum allowed amount. For LIVE CPM modes, the
   * default amount is $0.01. This value is ignored if `cpm_mode` is `LIVE`. **Warning:** "USD" is
   * the only supported currency at the moment. The unit is in micros.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long cpmMicros;

  /**
   * Indicates how the CPM for this mediation line is provided. Note that `MANUAL` and `LIVE` are
   * the only fully-supported mode at the moment. Please use the AdMob UI (https://admob.google.com)
   * if you wish to create or update to other cpm modes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cpmMode;

  /**
   * User-provided label for this mediation line. The maximum length allowed is 255 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. The Mediation A/B experiment variant to which the mediation group line belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String experimentVariant;

  /**
   * The 16 digit ID for this mediation line e.g. 0123456789012345. When creating a new mediation
   * group line, use a distinct negative integer as the ID place holder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The status of the mediation group line. Only enabled mediation group lines will be served.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The ID of the ad source this mediation line is associated with.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdSourceId() {
    return adSourceId;
  }

  /**
   * The ID of the ad source this mediation line is associated with.
   * @param adSourceId adSourceId or {@code null} for none
   */
  public MediationGroupMediationGroupLine setAdSourceId(java.lang.String adSourceId) {
    this.adSourceId = adSourceId;
    return this;
  }

  /**
   * References of the ad unit mappings for each ad unit associated with this mediation line. Key is
   * the ad unit ID, value is resource name of the ad unit mapping. For mediation lines where the ad
   * source id is the AdMob Network, ad unit mappings will be ignored.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getAdUnitMappings() {
    return adUnitMappings;
  }

  /**
   * References of the ad unit mappings for each ad unit associated with this mediation line. Key is
   * the ad unit ID, value is resource name of the ad unit mapping. For mediation lines where the ad
   * source id is the AdMob Network, ad unit mappings will be ignored.
   * @param adUnitMappings adUnitMappings or {@code null} for none
   */
  public MediationGroupMediationGroupLine setAdUnitMappings(java.util.Map<String, java.lang.String> adUnitMappings) {
    this.adUnitMappings = adUnitMappings;
    return this;
  }

  /**
   * The CPM for this allocation line. $0.01 is the minimum allowed amount. For LIVE CPM modes, the
   * default amount is $0.01. This value is ignored if `cpm_mode` is `LIVE`. **Warning:** "USD" is
   * the only supported currency at the moment. The unit is in micros.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCpmMicros() {
    return cpmMicros;
  }

  /**
   * The CPM for this allocation line. $0.01 is the minimum allowed amount. For LIVE CPM modes, the
   * default amount is $0.01. This value is ignored if `cpm_mode` is `LIVE`. **Warning:** "USD" is
   * the only supported currency at the moment. The unit is in micros.
   * @param cpmMicros cpmMicros or {@code null} for none
   */
  public MediationGroupMediationGroupLine setCpmMicros(java.lang.Long cpmMicros) {
    this.cpmMicros = cpmMicros;
    return this;
  }

  /**
   * Indicates how the CPM for this mediation line is provided. Note that `MANUAL` and `LIVE` are
   * the only fully-supported mode at the moment. Please use the AdMob UI (https://admob.google.com)
   * if you wish to create or update to other cpm modes.
   * @return value or {@code null} for none
   */
  public java.lang.String getCpmMode() {
    return cpmMode;
  }

  /**
   * Indicates how the CPM for this mediation line is provided. Note that `MANUAL` and `LIVE` are
   * the only fully-supported mode at the moment. Please use the AdMob UI (https://admob.google.com)
   * if you wish to create or update to other cpm modes.
   * @param cpmMode cpmMode or {@code null} for none
   */
  public MediationGroupMediationGroupLine setCpmMode(java.lang.String cpmMode) {
    this.cpmMode = cpmMode;
    return this;
  }

  /**
   * User-provided label for this mediation line. The maximum length allowed is 255 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * User-provided label for this mediation line. The maximum length allowed is 255 characters.
   * @param displayName displayName or {@code null} for none
   */
  public MediationGroupMediationGroupLine setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. The Mediation A/B experiment variant to which the mediation group line belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getExperimentVariant() {
    return experimentVariant;
  }

  /**
   * Output only. The Mediation A/B experiment variant to which the mediation group line belongs to.
   * @param experimentVariant experimentVariant or {@code null} for none
   */
  public MediationGroupMediationGroupLine setExperimentVariant(java.lang.String experimentVariant) {
    this.experimentVariant = experimentVariant;
    return this;
  }

  /**
   * The 16 digit ID for this mediation line e.g. 0123456789012345. When creating a new mediation
   * group line, use a distinct negative integer as the ID place holder.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The 16 digit ID for this mediation line e.g. 0123456789012345. When creating a new mediation
   * group line, use a distinct negative integer as the ID place holder.
   * @param id id or {@code null} for none
   */
  public MediationGroupMediationGroupLine setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The status of the mediation group line. Only enabled mediation group lines will be served.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The status of the mediation group line. Only enabled mediation group lines will be served.
   * @param state state or {@code null} for none
   */
  public MediationGroupMediationGroupLine setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public MediationGroupMediationGroupLine set(String fieldName, Object value) {
    return (MediationGroupMediationGroupLine) super.set(fieldName, value);
  }

  @Override
  public MediationGroupMediationGroupLine clone() {
    return (MediationGroupMediationGroupLine) super.clone();
  }

}
