/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta;

/**
 * Service definition for GoogleAnalyticsAdmin (v1beta).
 *
 * <p>
 * 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="http://code.google.com/apis/analytics/docs/mgmt/home.html" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link GoogleAnalyticsAdminRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class GoogleAnalyticsAdmin extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Analytics Admin API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://analyticsadmin.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://analyticsadmin.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public GoogleAnalyticsAdmin(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  GoogleAnalyticsAdmin(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the AccountSummaries collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
   *   {@code GoogleAnalyticsAdmin.AccountSummaries.List request = analyticsadmin.accountSummaries().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public AccountSummaries accountSummaries() {
    return new AccountSummaries();
  }

  /**
   * The "accountSummaries" collection of methods.
   */
  public class AccountSummaries {

    /**
     * Returns summaries of all accounts accessible by the caller.
     *
     * Create a request for the method "accountSummaries.list".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListAccountSummariesResponse> {

      private static final String REST_PATH = "v1beta/accountSummaries";

      /**
       * Returns summaries of all accounts accessible by the caller.
       *
       * Create a request for the method "accountSummaries.list".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListAccountSummariesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The maximum number of AccountSummary resources to return. The service may return fewer than
       * this value, even if there are additional pages. If unspecified, at most 50 resources will
       * be returned. The maximum value is 200; (higher values will be coerced to the maximum)
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of AccountSummary resources to return. The service may return fewer than this
     value, even if there are additional pages. If unspecified, at most 50 resources will be returned.
     The maximum value is 200; (higher values will be coerced to the maximum)
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of AccountSummary resources to return. The service may return fewer than
       * this value, even if there are additional pages. If unspecified, at most 50 resources will
       * be returned. The maximum value is 200; (higher values will be coerced to the maximum)
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * A page token, received from a previous `ListAccountSummaries` call. Provide this to
       * retrieve the subsequent page. When paginating, all other parameters provided to
       * `ListAccountSummaries` must match the call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A page token, received from a previous `ListAccountSummaries` call. Provide this to retrieve the
     subsequent page. When paginating, all other parameters provided to `ListAccountSummaries` must
     match the call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A page token, received from a previous `ListAccountSummaries` call. Provide this to
       * retrieve the subsequent page. When paginating, all other parameters provided to
       * `ListAccountSummaries` must match the call that provided the page token.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Accounts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
   *   {@code GoogleAnalyticsAdmin.Accounts.List request = analyticsadmin.accounts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Accounts accounts() {
    return new Accounts();
  }

  /**
   * The "accounts" collection of methods.
   */
  public class Accounts {

    /**
     * Marks target Account as soft-deleted (ie: "trashed") and returns it. This API does not have a
     * method to restore soft-deleted accounts. However, they can be restored using the Trash Can UI. If
     * the accounts are not restored before the expiration time, the account and all child resources
     * (eg: Properties, GoogleAdsLinks, Streams, UserLinks) will be permanently purged.
     * https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found.
     *
     * Create a request for the method "accounts.delete".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the Account to soft-delete. Format: accounts/{account} Example: "accounts/100"
     * @return the request
     */
    public Delete delete(java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(name);
      initialize(result);
      return result;
    }

    public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Marks target Account as soft-deleted (ie: "trashed") and returns it. This API does not have a
       * method to restore soft-deleted accounts. However, they can be restored using the Trash Can UI.
       * If the accounts are not restored before the expiration time, the account and all child
       * resources (eg: Properties, GoogleAdsLinks, Streams, UserLinks) will be permanently purged.
       * https://support.google.com/analytics/answer/6154772 Returns an error if the target is not
       * found.
       *
       * Create a request for the method "accounts.delete".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the Account to soft-delete. Format: accounts/{account} Example: "accounts/100"
       * @since 1.13
       */
      protected Delete(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the Account to soft-delete. Format: accounts/{account} Example:
       * "accounts/100"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the Account to soft-delete. Format: accounts/{account} Example:
     "accounts/100"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the Account to soft-delete. Format: accounts/{account} Example:
       * "accounts/100"
       */
      public Delete setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Lookup for a single Account.
     *
     * Create a request for the method "accounts.get".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the account to lookup. Format: accounts/{account} Example: "accounts/100"
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Lookup for a single Account.
       *
       * Create a request for the method "accounts.get".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the account to lookup. Format: accounts/{account} Example: "accounts/100"
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the account to lookup. Format: accounts/{account} Example:
       * "accounts/100"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the account to lookup. Format: accounts/{account} Example: "accounts/100"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the account to lookup. Format: accounts/{account} Example:
       * "accounts/100"
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Get data sharing settings on an account. Data sharing settings are singletons.
     *
     * Create a request for the method "accounts.getDataSharingSettings".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link GetDataSharingSettings#execute()} method to invoke the
     * remote operation.
     *
     * @param name Required. The name of the settings to lookup. Format: accounts/{account}/dataSharingSettings
     *        Example: "accounts/1000/dataSharingSettings"
     * @return the request
     */
    public GetDataSharingSettings getDataSharingSettings(java.lang.String name) throws java.io.IOException {
      GetDataSharingSettings result = new GetDataSharingSettings(name);
      initialize(result);
      return result;
    }

    public class GetDataSharingSettings extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataSharingSettings> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+/dataSharingSettings$");

      /**
       * Get data sharing settings on an account. Data sharing settings are singletons.
       *
       * Create a request for the method "accounts.getDataSharingSettings".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link GetDataSharingSettings#execute()} method to invoke the
       * remote operation. <p> {@link GetDataSharingSettings#initialize(com.google.api.client.googleapis
       * .services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param name Required. The name of the settings to lookup. Format: accounts/{account}/dataSharingSettings
     *        Example: "accounts/1000/dataSharingSettings"
       * @since 1.13
       */
      protected GetDataSharingSettings(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataSharingSettings.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/dataSharingSettings$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetDataSharingSettings set$Xgafv(java.lang.String $Xgafv) {
        return (GetDataSharingSettings) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetDataSharingSettings setAccessToken(java.lang.String accessToken) {
        return (GetDataSharingSettings) super.setAccessToken(accessToken);
      }

      @Override
      public GetDataSharingSettings setAlt(java.lang.String alt) {
        return (GetDataSharingSettings) super.setAlt(alt);
      }

      @Override
      public GetDataSharingSettings setCallback(java.lang.String callback) {
        return (GetDataSharingSettings) super.setCallback(callback);
      }

      @Override
      public GetDataSharingSettings setFields(java.lang.String fields) {
        return (GetDataSharingSettings) super.setFields(fields);
      }

      @Override
      public GetDataSharingSettings setKey(java.lang.String key) {
        return (GetDataSharingSettings) super.setKey(key);
      }

      @Override
      public GetDataSharingSettings setOauthToken(java.lang.String oauthToken) {
        return (GetDataSharingSettings) super.setOauthToken(oauthToken);
      }

      @Override
      public GetDataSharingSettings setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetDataSharingSettings) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetDataSharingSettings setQuotaUser(java.lang.String quotaUser) {
        return (GetDataSharingSettings) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetDataSharingSettings setUploadType(java.lang.String uploadType) {
        return (GetDataSharingSettings) super.setUploadType(uploadType);
      }

      @Override
      public GetDataSharingSettings setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetDataSharingSettings) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the settings to lookup. Format:
       * accounts/{account}/dataSharingSettings Example: "accounts/1000/dataSharingSettings"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the settings to lookup. Format: accounts/{account}/dataSharingSettings
     Example: "accounts/1000/dataSharingSettings"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the settings to lookup. Format:
       * accounts/{account}/dataSharingSettings Example: "accounts/1000/dataSharingSettings"
       */
      public GetDataSharingSettings setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/dataSharingSettings$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GetDataSharingSettings set(String parameterName, Object value) {
        return (GetDataSharingSettings) super.set(parameterName, value);
      }
    }
    /**
     * Returns all accounts accessible by the caller. Note that these accounts might not currently have
     * GA4 properties. Soft-deleted (ie: "trashed") accounts are excluded by default. Returns an empty
     * list if no relevant accounts are found.
     *
     * Create a request for the method "accounts.list".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListAccountsResponse> {

      private static final String REST_PATH = "v1beta/accounts";

      /**
       * Returns all accounts accessible by the caller. Note that these accounts might not currently
       * have GA4 properties. Soft-deleted (ie: "trashed") accounts are excluded by default. Returns an
       * empty list if no relevant accounts are found.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListAccountsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The maximum number of resources to return. The service may return fewer than this value,
       * even if there are additional pages. If unspecified, at most 50 resources will be returned.
       * The maximum value is 200; (higher values will be coerced to the maximum)
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of resources to return. The service may return fewer than this value, even if
     there are additional pages. If unspecified, at most 50 resources will be returned. The maximum
     value is 200; (higher values will be coerced to the maximum)
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of resources to return. The service may return fewer than this value,
       * even if there are additional pages. If unspecified, at most 50 resources will be returned.
       * The maximum value is 200; (higher values will be coerced to the maximum)
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * A page token, received from a previous `ListAccounts` call. Provide this to retrieve the
       * subsequent page. When paginating, all other parameters provided to `ListAccounts` must
       * match the call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent
     page. When paginating, all other parameters provided to `ListAccounts` must match the call that
     provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A page token, received from a previous `ListAccounts` call. Provide this to retrieve the
       * subsequent page. When paginating, all other parameters provided to `ListAccounts` must
       * match the call that provided the page token.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include soft-deleted (ie: "trashed") Accounts in the results. Accounts can be
       * inspected to determine whether they are deleted or not.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include soft-deleted (ie: "trashed") Accounts in the results. Accounts can be inspected
     to determine whether they are deleted or not.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include soft-deleted (ie: "trashed") Accounts in the results. Accounts can be
       * inspected to determine whether they are deleted or not.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an account.
     *
     * Create a request for the method "accounts.patch".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param name Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount}
     * @return the request
     */
    public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount content) throws java.io.IOException {
      Patch result = new Patch(name, content);
      initialize(result);
      return result;
    }

    public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Updates an account.
       *
       * Create a request for the method "accounts.patch".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount}
       * @since 1.13
       */
      protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount content) {
        super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAccount.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Output only. Resource name of this account. Format: accounts/{account} Example:
       * "accounts/100"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Output only. Resource name of this account. Format: accounts/{account} Example:
       * "accounts/100"
       */
      public Patch setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (for example,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      @com.google.api.client.util.Key
      private String updateMask;

      /** Required. The list of fields to be updated. Field names must be in snake case (for example,
     "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use one path
     with the string "*" to match all fields.
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (for example,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      public Patch setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Requests a ticket for creating an account.
     *
     * Create a request for the method "accounts.provisionAccountTicket".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link ProvisionAccountTicket#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest}
     * @return the request
     */
    public ProvisionAccountTicket provisionAccountTicket(com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest content) throws java.io.IOException {
      ProvisionAccountTicket result = new ProvisionAccountTicket(content);
      initialize(result);
      return result;
    }

    public class ProvisionAccountTicket extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse> {

      private static final String REST_PATH = "v1beta/accounts:provisionAccountTicket";

      /**
       * Requests a ticket for creating an account.
       *
       * Create a request for the method "accounts.provisionAccountTicket".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link ProvisionAccountTicket#execute()} method to invoke the
       * remote operation. <p> {@link ProvisionAccountTicket#initialize(com.google.api.client.googleapis
       * .services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest}
       * @since 1.13
       */
      protected ProvisionAccountTicket(com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketRequest content) {
        super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProvisionAccountTicketResponse.class);
      }

      @Override
      public ProvisionAccountTicket set$Xgafv(java.lang.String $Xgafv) {
        return (ProvisionAccountTicket) super.set$Xgafv($Xgafv);
      }

      @Override
      public ProvisionAccountTicket setAccessToken(java.lang.String accessToken) {
        return (ProvisionAccountTicket) super.setAccessToken(accessToken);
      }

      @Override
      public ProvisionAccountTicket setAlt(java.lang.String alt) {
        return (ProvisionAccountTicket) super.setAlt(alt);
      }

      @Override
      public ProvisionAccountTicket setCallback(java.lang.String callback) {
        return (ProvisionAccountTicket) super.setCallback(callback);
      }

      @Override
      public ProvisionAccountTicket setFields(java.lang.String fields) {
        return (ProvisionAccountTicket) super.setFields(fields);
      }

      @Override
      public ProvisionAccountTicket setKey(java.lang.String key) {
        return (ProvisionAccountTicket) super.setKey(key);
      }

      @Override
      public ProvisionAccountTicket setOauthToken(java.lang.String oauthToken) {
        return (ProvisionAccountTicket) super.setOauthToken(oauthToken);
      }

      @Override
      public ProvisionAccountTicket setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ProvisionAccountTicket) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ProvisionAccountTicket setQuotaUser(java.lang.String quotaUser) {
        return (ProvisionAccountTicket) super.setQuotaUser(quotaUser);
      }

      @Override
      public ProvisionAccountTicket setUploadType(java.lang.String uploadType) {
        return (ProvisionAccountTicket) super.setUploadType(uploadType);
      }

      @Override
      public ProvisionAccountTicket setUploadProtocol(java.lang.String uploadProtocol) {
        return (ProvisionAccountTicket) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public ProvisionAccountTicket set(String parameterName, Object value) {
        return (ProvisionAccountTicket) super.set(parameterName, value);
      }
    }
    /**
     * Searches through all changes to an account or its children given the specified set of filters.
     *
     * Create a request for the method "accounts.searchChangeHistoryEvents".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link SearchChangeHistoryEvents#execute()} method to invoke the
     * remote operation.
     *
     * @param account Required. The account resource for which to return change history resources.
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest}
     * @return the request
     */
    public SearchChangeHistoryEvents searchChangeHistoryEvents(java.lang.String account, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest content) throws java.io.IOException {
      SearchChangeHistoryEvents result = new SearchChangeHistoryEvents(account, content);
      initialize(result);
      return result;
    }

    public class SearchChangeHistoryEvents extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse> {

      private static final String REST_PATH = "v1beta/{+account}:searchChangeHistoryEvents";

      private final java.util.regex.Pattern ACCOUNT_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Searches through all changes to an account or its children given the specified set of filters.
       *
       * Create a request for the method "accounts.searchChangeHistoryEvents".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link SearchChangeHistoryEvents#execute()} method to invoke the
       * remote operation. <p> {@link SearchChangeHistoryEvents#initialize(com.google.api.client.googlea
       * pis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param account Required. The account resource for which to return change history resources.
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest}
       * @since 1.13
       */
      protected SearchChangeHistoryEvents(java.lang.String account, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsRequest content) {
        super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaSearchChangeHistoryEventsResponse.class);
        this.account = com.google.api.client.util.Preconditions.checkNotNull(account, "Required parameter account must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_PATTERN.matcher(account).matches(),
              "Parameter account must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public SearchChangeHistoryEvents set$Xgafv(java.lang.String $Xgafv) {
        return (SearchChangeHistoryEvents) super.set$Xgafv($Xgafv);
      }

      @Override
      public SearchChangeHistoryEvents setAccessToken(java.lang.String accessToken) {
        return (SearchChangeHistoryEvents) super.setAccessToken(accessToken);
      }

      @Override
      public SearchChangeHistoryEvents setAlt(java.lang.String alt) {
        return (SearchChangeHistoryEvents) super.setAlt(alt);
      }

      @Override
      public SearchChangeHistoryEvents setCallback(java.lang.String callback) {
        return (SearchChangeHistoryEvents) super.setCallback(callback);
      }

      @Override
      public SearchChangeHistoryEvents setFields(java.lang.String fields) {
        return (SearchChangeHistoryEvents) super.setFields(fields);
      }

      @Override
      public SearchChangeHistoryEvents setKey(java.lang.String key) {
        return (SearchChangeHistoryEvents) super.setKey(key);
      }

      @Override
      public SearchChangeHistoryEvents setOauthToken(java.lang.String oauthToken) {
        return (SearchChangeHistoryEvents) super.setOauthToken(oauthToken);
      }

      @Override
      public SearchChangeHistoryEvents setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SearchChangeHistoryEvents) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SearchChangeHistoryEvents setQuotaUser(java.lang.String quotaUser) {
        return (SearchChangeHistoryEvents) super.setQuotaUser(quotaUser);
      }

      @Override
      public SearchChangeHistoryEvents setUploadType(java.lang.String uploadType) {
        return (SearchChangeHistoryEvents) super.setUploadType(uploadType);
      }

      @Override
      public SearchChangeHistoryEvents setUploadProtocol(java.lang.String uploadProtocol) {
        return (SearchChangeHistoryEvents) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The account resource for which to return change history resources. */
      @com.google.api.client.util.Key
      private java.lang.String account;

      /** Required. The account resource for which to return change history resources.
       */
      public java.lang.String getAccount() {
        return account;
      }

      /** Required. The account resource for which to return change history resources. */
      public SearchChangeHistoryEvents setAccount(java.lang.String account) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCOUNT_PATTERN.matcher(account).matches(),
              "Parameter account must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.account = account;
        return this;
      }

      @Override
      public SearchChangeHistoryEvents set(String parameterName, Object value) {
        return (SearchChangeHistoryEvents) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Properties collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
   *   {@code GoogleAnalyticsAdmin.Properties.List request = analyticsadmin.properties().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Properties properties() {
    return new Properties();
  }

  /**
   * The "properties" collection of methods.
   */
  public class Properties {

    /**
     * Acknowledges the terms of user data collection for the specified property. This acknowledgement
     * must be completed (either in the Google Analytics UI or through this API) before
     * MeasurementProtocolSecret resources may be created.
     *
     * Create a request for the method "properties.acknowledgeUserDataCollection".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link AcknowledgeUserDataCollection#execute()} method to invoke
     * the remote operation.
     *
     * @param property Required. The property for which to acknowledge user data collection.
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest}
     * @return the request
     */
    public AcknowledgeUserDataCollection acknowledgeUserDataCollection(java.lang.String property, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest content) throws java.io.IOException {
      AcknowledgeUserDataCollection result = new AcknowledgeUserDataCollection(property, content);
      initialize(result);
      return result;
    }

    public class AcknowledgeUserDataCollection extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse> {

      private static final String REST_PATH = "v1beta/{+property}:acknowledgeUserDataCollection";

      private final java.util.regex.Pattern PROPERTY_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Acknowledges the terms of user data collection for the specified property. This acknowledgement
       * must be completed (either in the Google Analytics UI or through this API) before
       * MeasurementProtocolSecret resources may be created.
       *
       * Create a request for the method "properties.acknowledgeUserDataCollection".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link AcknowledgeUserDataCollection#execute()} method to invoke
       * the remote operation. <p> {@link AcknowledgeUserDataCollection#initialize(com.google.api.client
       * .googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param property Required. The property for which to acknowledge user data collection.
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest}
       * @since 1.13
       */
      protected AcknowledgeUserDataCollection(java.lang.String property, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionRequest content) {
        super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaAcknowledgeUserDataCollectionResponse.class);
        this.property = com.google.api.client.util.Preconditions.checkNotNull(property, "Required parameter property must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public AcknowledgeUserDataCollection set$Xgafv(java.lang.String $Xgafv) {
        return (AcknowledgeUserDataCollection) super.set$Xgafv($Xgafv);
      }

      @Override
      public AcknowledgeUserDataCollection setAccessToken(java.lang.String accessToken) {
        return (AcknowledgeUserDataCollection) super.setAccessToken(accessToken);
      }

      @Override
      public AcknowledgeUserDataCollection setAlt(java.lang.String alt) {
        return (AcknowledgeUserDataCollection) super.setAlt(alt);
      }

      @Override
      public AcknowledgeUserDataCollection setCallback(java.lang.String callback) {
        return (AcknowledgeUserDataCollection) super.setCallback(callback);
      }

      @Override
      public AcknowledgeUserDataCollection setFields(java.lang.String fields) {
        return (AcknowledgeUserDataCollection) super.setFields(fields);
      }

      @Override
      public AcknowledgeUserDataCollection setKey(java.lang.String key) {
        return (AcknowledgeUserDataCollection) super.setKey(key);
      }

      @Override
      public AcknowledgeUserDataCollection setOauthToken(java.lang.String oauthToken) {
        return (AcknowledgeUserDataCollection) super.setOauthToken(oauthToken);
      }

      @Override
      public AcknowledgeUserDataCollection setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AcknowledgeUserDataCollection) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AcknowledgeUserDataCollection setQuotaUser(java.lang.String quotaUser) {
        return (AcknowledgeUserDataCollection) super.setQuotaUser(quotaUser);
      }

      @Override
      public AcknowledgeUserDataCollection setUploadType(java.lang.String uploadType) {
        return (AcknowledgeUserDataCollection) super.setUploadType(uploadType);
      }

      @Override
      public AcknowledgeUserDataCollection setUploadProtocol(java.lang.String uploadProtocol) {
        return (AcknowledgeUserDataCollection) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The property for which to acknowledge user data collection. */
      @com.google.api.client.util.Key
      private java.lang.String property;

      /** Required. The property for which to acknowledge user data collection.
       */
      public java.lang.String getProperty() {
        return property;
      }

      /** Required. The property for which to acknowledge user data collection. */
      public AcknowledgeUserDataCollection setProperty(java.lang.String property) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROPERTY_PATTERN.matcher(property).matches(),
              "Parameter property must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.property = property;
        return this;
      }

      @Override
      public AcknowledgeUserDataCollection set(String parameterName, Object value) {
        return (AcknowledgeUserDataCollection) super.set(parameterName, value);
      }
    }
    /**
     * Creates an "GA4" property with the specified location and attributes.
     *
     * Create a request for the method "properties.create".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty}
     * @return the request
     */
    public Create create(com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty> {

      private static final String REST_PATH = "v1beta/properties";

      /**
       * Creates an "GA4" property with the specified location and attributes.
       *
       * Create a request for the method "properties.create".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       * <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty}
       * @since 1.13
       */
      protected Create(com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty content) {
        super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Marks target Property as soft-deleted (ie: "trashed") and returns it. This API does not have a
     * method to restore soft-deleted properties. However, they can be restored using the Trash Can UI.
     * If the properties are not restored before the expiration time, the Property and all child
     * resources (eg: GoogleAdsLinks, Streams, UserLinks) will be permanently purged.
     * https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found,
     * or is not a GA4 Property.
     *
     * Create a request for the method "properties.delete".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the Property to soft-delete. Format: properties/{property_id} Example:
     *        "properties/1000"
     * @return the request
     */
    public Delete delete(java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(name);
      initialize(result);
      return result;
    }

    public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Marks target Property as soft-deleted (ie: "trashed") and returns it. This API does not have a
       * method to restore soft-deleted properties. However, they can be restored using the Trash Can
       * UI. If the properties are not restored before the expiration time, the Property and all child
       * resources (eg: GoogleAdsLinks, Streams, UserLinks) will be permanently purged.
       * https://support.google.com/analytics/answer/6154772 Returns an error if the target is not
       * found, or is not a GA4 Property.
       *
       * Create a request for the method "properties.delete".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the Property to soft-delete. Format: properties/{property_id} Example:
     *        "properties/1000"
       * @since 1.13
       */
      protected Delete(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the Property to soft-delete. Format: properties/{property_id}
       * Example: "properties/1000"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the Property to soft-delete. Format: properties/{property_id} Example:
     "properties/1000"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the Property to soft-delete. Format: properties/{property_id}
       * Example: "properties/1000"
       */
      public Delete setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Lookup for a single "GA4" Property.
     *
     * Create a request for the method "properties.get".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Required. The name of the property to lookup. Format: properties/{property_id} Example:
     *        "properties/1000"
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Lookup for a single "GA4" Property.
       *
       * Create a request for the method "properties.get".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the property to lookup. Format: properties/{property_id} Example:
     *        "properties/1000"
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the property to lookup. Format: properties/{property_id} Example:
       * "properties/1000"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the property to lookup. Format: properties/{property_id} Example:
     "properties/1000"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the property to lookup. Format: properties/{property_id} Example:
       * "properties/1000"
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the singleton data retention settings for this property.
     *
     * Create a request for the method "properties.getDataRetentionSettings".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link GetDataRetentionSettings#execute()} method to invoke the
     * remote operation.
     *
     * @param name Required. The name of the settings to lookup. Format: properties/{property}/dataRetentionSettings
     *        Example: "properties/1000/dataRetentionSettings"
     * @return the request
     */
    public GetDataRetentionSettings getDataRetentionSettings(java.lang.String name) throws java.io.IOException {
      GetDataRetentionSettings result = new GetDataRetentionSettings(name);
      initialize(result);
      return result;
    }

    public class GetDataRetentionSettings extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+/dataRetentionSettings$");

      /**
       * Returns the singleton data retention settings for this property.
       *
       * Create a request for the method "properties.getDataRetentionSettings".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link GetDataRetentionSettings#execute()} method to invoke the
       * remote operation. <p> {@link GetDataRetentionSettings#initialize(com.google.api.client.googleap
       * is.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the settings to lookup. Format: properties/{property}/dataRetentionSettings
     *        Example: "properties/1000/dataRetentionSettings"
       * @since 1.13
       */
      protected GetDataRetentionSettings(java.lang.String name) {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/dataRetentionSettings$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetDataRetentionSettings set$Xgafv(java.lang.String $Xgafv) {
        return (GetDataRetentionSettings) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetDataRetentionSettings setAccessToken(java.lang.String accessToken) {
        return (GetDataRetentionSettings) super.setAccessToken(accessToken);
      }

      @Override
      public GetDataRetentionSettings setAlt(java.lang.String alt) {
        return (GetDataRetentionSettings) super.setAlt(alt);
      }

      @Override
      public GetDataRetentionSettings setCallback(java.lang.String callback) {
        return (GetDataRetentionSettings) super.setCallback(callback);
      }

      @Override
      public GetDataRetentionSettings setFields(java.lang.String fields) {
        return (GetDataRetentionSettings) super.setFields(fields);
      }

      @Override
      public GetDataRetentionSettings setKey(java.lang.String key) {
        return (GetDataRetentionSettings) super.setKey(key);
      }

      @Override
      public GetDataRetentionSettings setOauthToken(java.lang.String oauthToken) {
        return (GetDataRetentionSettings) super.setOauthToken(oauthToken);
      }

      @Override
      public GetDataRetentionSettings setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetDataRetentionSettings) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetDataRetentionSettings setQuotaUser(java.lang.String quotaUser) {
        return (GetDataRetentionSettings) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetDataRetentionSettings setUploadType(java.lang.String uploadType) {
        return (GetDataRetentionSettings) super.setUploadType(uploadType);
      }

      @Override
      public GetDataRetentionSettings setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetDataRetentionSettings) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The name of the settings to lookup. Format:
       * properties/{property}/dataRetentionSettings Example:
       * "properties/1000/dataRetentionSettings"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the settings to lookup. Format: properties/{property}/dataRetentionSettings
     Example: "properties/1000/dataRetentionSettings"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. The name of the settings to lookup. Format:
       * properties/{property}/dataRetentionSettings Example:
       * "properties/1000/dataRetentionSettings"
       */
      public GetDataRetentionSettings setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/dataRetentionSettings$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GetDataRetentionSettings set(String parameterName, Object value) {
        return (GetDataRetentionSettings) super.set(parameterName, value);
      }
    }
    /**
     * Returns child Properties under the specified parent Account. Only "GA4" properties will be
     * returned. Properties will be excluded if the caller does not have access. Soft-deleted (ie:
     * "trashed") properties are excluded by default. Returns an empty list if no relevant properties
     * are found.
     *
     * Create a request for the method "properties.list".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListPropertiesResponse> {

      private static final String REST_PATH = "v1beta/properties";

      /**
       * Returns child Properties under the specified parent Account. Only "GA4" properties will be
       * returned. Properties will be excluded if the caller does not have access. Soft-deleted (ie:
       * "trashed") properties are excluded by default. Returns an empty list if no relevant properties
       * are found.
       *
       * Create a request for the method "properties.list".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListPropertiesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. An expression for filtering the results of the request. Fields eligible for
       * filtering are: `parent:`(The resource name of the parent account/property) or
       * `ancestor:`(The resource name of the parent account) or `firebase_project:`(The id or
       * number of the linked firebase project). Some examples of filters: ``` | Filter |
       * Description | |-----------------------------|-------------------------------------------| |
       * parent:accounts/123 | The account with account id: 123. | | parent:properties/123 | The
       * property with property id: 123. | | ancestor:accounts/123 | The account with account id:
       * 123. | | firebase_project:project-id | The firebase project with id: project-id. | |
       * firebase_project:123 | The firebase project with number: 123. | ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Required. An expression for filtering the results of the request. Fields eligible for filtering
     are: `parent:`(The resource name of the parent account/property) or `ancestor:`(The resource name
     of the parent account) or `firebase_project:`(The id or number of the linked firebase project).
     Some examples of filters: ``` | Filter | Description |
     |-----------------------------|-------------------------------------------| | parent:accounts/123 |
     The account with account id: 123. | | parent:properties/123 | The property with property id: 123. |
     | ancestor:accounts/123 | The account with account id: 123. | | firebase_project:project-id | The
     firebase project with id: project-id. | | firebase_project:123 | The firebase project with number:
     123. | ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Required. An expression for filtering the results of the request. Fields eligible for
       * filtering are: `parent:`(The resource name of the parent account/property) or
       * `ancestor:`(The resource name of the parent account) or `firebase_project:`(The id or
       * number of the linked firebase project). Some examples of filters: ``` | Filter |
       * Description | |-----------------------------|-------------------------------------------| |
       * parent:accounts/123 | The account with account id: 123. | | parent:properties/123 | The
       * property with property id: 123. | | ancestor:accounts/123 | The account with account id:
       * 123. | | firebase_project:project-id | The firebase project with id: project-id. | |
       * firebase_project:123 | The firebase project with number: 123. | ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of resources to return. The service may return fewer than this value,
       * even if there are additional pages. If unspecified, at most 50 resources will be returned.
       * The maximum value is 200; (higher values will be coerced to the maximum)
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of resources to return. The service may return fewer than this value, even if
     there are additional pages. If unspecified, at most 50 resources will be returned. The maximum
     value is 200; (higher values will be coerced to the maximum)
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of resources to return. The service may return fewer than this value,
       * even if there are additional pages. If unspecified, at most 50 resources will be returned.
       * The maximum value is 200; (higher values will be coerced to the maximum)
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * A page token, received from a previous `ListProperties` call. Provide this to retrieve the
       * subsequent page. When paginating, all other parameters provided to `ListProperties` must
       * match the call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A page token, received from a previous `ListProperties` call. Provide this to retrieve the
     subsequent page. When paginating, all other parameters provided to `ListProperties` must match the
     call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A page token, received from a previous `ListProperties` call. Provide this to retrieve the
       * subsequent page. When paginating, all other parameters provided to `ListProperties` must
       * match the call that provided the page token.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include soft-deleted (ie: "trashed") Properties in the results. Properties can
       * be inspected to determine whether they are deleted or not.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include soft-deleted (ie: "trashed") Properties in the results. Properties can be
     inspected to determine whether they are deleted or not.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include soft-deleted (ie: "trashed") Properties in the results. Properties can
       * be inspected to determine whether they are deleted or not.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a property.
     *
     * Create a request for the method "properties.patch".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param name Output only. Resource name of this property. Format: properties/{property_id} Example:
     *        "properties/1000"
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty}
     * @return the request
     */
    public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty content) throws java.io.IOException {
      Patch result = new Patch(name, content);
      initialize(result);
      return result;
    }

    public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+$");

      /**
       * Updates a property.
       *
       * Create a request for the method "properties.patch".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Output only. Resource name of this property. Format: properties/{property_id} Example:
     *        "properties/1000"
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty}
       * @since 1.13
       */
      protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty content) {
        super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaProperty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Output only. Resource name of this property. Format: properties/{property_id} Example:
       * "properties/1000"
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Output only. Resource name of this property. Format: properties/{property_id} Example:
     "properties/1000"
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Output only. Resource name of this property. Format: properties/{property_id} Example:
       * "properties/1000"
       */
      public Patch setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      @com.google.api.client.util.Key
      private String updateMask;

      /** Required. The list of fields to be updated. Field names must be in snake case (e.g.,
     "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use one path
     with the string "*" to match all fields.
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      public Patch setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the singleton data retention settings for this property.
     *
     * Create a request for the method "properties.updateDataRetentionSettings".
     *
     * This request holds the parameters needed by the analyticsadmin server.  After setting any
     * optional parameters, call the {@link UpdateDataRetentionSettings#execute()} method to invoke the
     * remote operation.
     *
     * @param name Output only. Resource name for this DataRetentionSetting resource. Format:
     *        properties/{property}/dataRetentionSettings
     * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings}
     * @return the request
     */
    public UpdateDataRetentionSettings updateDataRetentionSettings(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings content) throws java.io.IOException {
      UpdateDataRetentionSettings result = new UpdateDataRetentionSettings(name, content);
      initialize(result);
      return result;
    }

    public class UpdateDataRetentionSettings extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings> {

      private static final String REST_PATH = "v1beta/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^properties/[^/]+/dataRetentionSettings$");

      /**
       * Updates the singleton data retention settings for this property.
       *
       * Create a request for the method "properties.updateDataRetentionSettings".
       *
       * This request holds the parameters needed by the the analyticsadmin server.  After setting any
       * optional parameters, call the {@link UpdateDataRetentionSettings#execute()} method to invoke
       * the remote operation. <p> {@link UpdateDataRetentionSettings#initialize(com.google.api.client.g
       * oogleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param name Output only. Resource name for this DataRetentionSetting resource. Format:
     *        properties/{property}/dataRetentionSettings
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings}
       * @since 1.13
       */
      protected UpdateDataRetentionSettings(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings content) {
        super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataRetentionSettings.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/dataRetentionSettings$");
        }
      }

      @Override
      public UpdateDataRetentionSettings set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateDataRetentionSettings) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateDataRetentionSettings setAccessToken(java.lang.String accessToken) {
        return (UpdateDataRetentionSettings) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateDataRetentionSettings setAlt(java.lang.String alt) {
        return (UpdateDataRetentionSettings) super.setAlt(alt);
      }

      @Override
      public UpdateDataRetentionSettings setCallback(java.lang.String callback) {
        return (UpdateDataRetentionSettings) super.setCallback(callback);
      }

      @Override
      public UpdateDataRetentionSettings setFields(java.lang.String fields) {
        return (UpdateDataRetentionSettings) super.setFields(fields);
      }

      @Override
      public UpdateDataRetentionSettings setKey(java.lang.String key) {
        return (UpdateDataRetentionSettings) super.setKey(key);
      }

      @Override
      public UpdateDataRetentionSettings setOauthToken(java.lang.String oauthToken) {
        return (UpdateDataRetentionSettings) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateDataRetentionSettings setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateDataRetentionSettings) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateDataRetentionSettings setQuotaUser(java.lang.String quotaUser) {
        return (UpdateDataRetentionSettings) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateDataRetentionSettings setUploadType(java.lang.String uploadType) {
        return (UpdateDataRetentionSettings) super.setUploadType(uploadType);
      }

      @Override
      public UpdateDataRetentionSettings setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateDataRetentionSettings) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Output only. Resource name for this DataRetentionSetting resource. Format:
       * properties/{property}/dataRetentionSettings
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Output only. Resource name for this DataRetentionSetting resource. Format:
     properties/{property}/dataRetentionSettings
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Output only. Resource name for this DataRetentionSetting resource. Format:
       * properties/{property}/dataRetentionSettings
       */
      public UpdateDataRetentionSettings setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^properties/[^/]+/dataRetentionSettings$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      @com.google.api.client.util.Key
      private String updateMask;

      /** Required. The list of fields to be updated. Field names must be in snake case (e.g.,
     "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use one path
     with the string "*" to match all fields.
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /**
       * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
       * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
       * one path with the string "*" to match all fields.
       */
      public UpdateDataRetentionSettings setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      @Override
      public UpdateDataRetentionSettings set(String parameterName, Object value) {
        return (UpdateDataRetentionSettings) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the ConversionEvents collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.ConversionEvents.List request = analyticsadmin.conversionEvents().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ConversionEvents conversionEvents() {
      return new ConversionEvents();
    }

    /**
     * The "conversionEvents" collection of methods.
     */
    public class ConversionEvents {

      /**
       * Creates a conversion event with the specified attributes.
       *
       * Create a request for the method "conversionEvents.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the parent property where this conversion event will be created.
       *        Format: properties/123
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent> {

        private static final String REST_PATH = "v1beta/{+parent}/conversionEvents";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a conversion event with the specified attributes.
         *
         * Create a request for the method "conversionEvents.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the parent property where this conversion event will be created.
       *        Format: properties/123
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the parent property where this conversion event will be
         * created. Format: properties/123
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the parent property where this conversion event will be created.
       Format: properties/123
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the parent property where this conversion event will be
         * created. Format: properties/123
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a conversion event in a property.
       *
       * Create a request for the method "conversionEvents.delete".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the conversion event to delete. Format:
       *        properties/{property}/conversionEvents/{conversion_event} Example:
       *        "properties/123/conversionEvents/456"
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/conversionEvents/[^/]+$");

        /**
         * Deletes a conversion event in a property.
         *
         * Create a request for the method "conversionEvents.delete".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the conversion event to delete. Format:
       *        properties/{property}/conversionEvents/{conversion_event} Example:
       *        "properties/123/conversionEvents/456"
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/conversionEvents/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the conversion event to delete. Format:
         * properties/{property}/conversionEvents/{conversion_event} Example:
         * "properties/123/conversionEvents/456"
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the conversion event to delete. Format:
       properties/{property}/conversionEvents/{conversion_event} Example:
       "properties/123/conversionEvents/456"
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the conversion event to delete. Format:
         * properties/{property}/conversionEvents/{conversion_event} Example:
         * "properties/123/conversionEvents/456"
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/conversionEvents/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Retrieve a single conversion event.
       *
       * Create a request for the method "conversionEvents.get".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name of the conversion event to retrieve. Format:
       *        properties/{property}/conversionEvents/{conversion_event} Example:
       *        "properties/123/conversionEvents/456"
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/conversionEvents/[^/]+$");

        /**
         * Retrieve a single conversion event.
         *
         * Create a request for the method "conversionEvents.get".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the conversion event to retrieve. Format:
       *        properties/{property}/conversionEvents/{conversion_event} Example:
       *        "properties/123/conversionEvents/456"
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaConversionEvent.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/conversionEvents/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the conversion event to retrieve. Format:
         * properties/{property}/conversionEvents/{conversion_event} Example:
         * "properties/123/conversionEvents/456"
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the conversion event to retrieve. Format:
       properties/{property}/conversionEvents/{conversion_event} Example:
       "properties/123/conversionEvents/456"
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the conversion event to retrieve. Format:
         * properties/{property}/conversionEvents/{conversion_event} Example:
         * "properties/123/conversionEvents/456"
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/conversionEvents/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Returns a list of conversion events in the specified parent property. Returns an empty list if no
       * conversion events are found.
       *
       * Create a request for the method "conversionEvents.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. The resource name of the parent property. Example: 'properties/123'
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListConversionEventsResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/conversionEvents";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Returns a list of conversion events in the specified parent property. Returns an empty list if
         * no conversion events are found.
         *
         * Create a request for the method "conversionEvents.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the parent property. Example: 'properties/123'
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListConversionEventsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name of the parent property. Example: 'properties/123' */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the parent property. Example: 'properties/123'
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. The resource name of the parent property. Example: 'properties/123' */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200; (higher values will be coerced to the maximum)
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. If unspecified, at most 50 resources will be returned.
       The maximum value is 200; (higher values will be coerced to the maximum)
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200; (higher values will be coerced to the maximum)
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListConversionEvents` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListConversionEvents` must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListConversionEvents` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListConversionEvents` must
       match the call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListConversionEvents` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListConversionEvents` must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomDimensions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.CustomDimensions.List request = analyticsadmin.customDimensions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomDimensions customDimensions() {
      return new CustomDimensions();
    }

    /**
     * The "customDimensions" collection of methods.
     */
    public class CustomDimensions {

      /**
       * Archives a CustomDimension on a property.
       *
       * Create a request for the method "customDimensions.archive".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Archive#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the CustomDimension to archive. Example format:
       *        properties/1234/customDimensions/5678
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest}
       * @return the request
       */
      public Archive archive(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest content) throws java.io.IOException {
        Archive result = new Archive(name, content);
        initialize(result);
        return result;
      }

      public class Archive extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}:archive";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customDimensions/[^/]+$");

        /**
         * Archives a CustomDimension on a property.
         *
         * Create a request for the method "customDimensions.archive".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Archive#execute()} method to invoke the remote operation.
         * <p> {@link
         * Archive#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the CustomDimension to archive. Example format:
       *        properties/1234/customDimensions/5678
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest}
         * @since 1.13
         */
        protected Archive(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomDimensionRequest content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
        }

        @Override
        public Archive set$Xgafv(java.lang.String $Xgafv) {
          return (Archive) super.set$Xgafv($Xgafv);
        }

        @Override
        public Archive setAccessToken(java.lang.String accessToken) {
          return (Archive) super.setAccessToken(accessToken);
        }

        @Override
        public Archive setAlt(java.lang.String alt) {
          return (Archive) super.setAlt(alt);
        }

        @Override
        public Archive setCallback(java.lang.String callback) {
          return (Archive) super.setCallback(callback);
        }

        @Override
        public Archive setFields(java.lang.String fields) {
          return (Archive) super.setFields(fields);
        }

        @Override
        public Archive setKey(java.lang.String key) {
          return (Archive) super.setKey(key);
        }

        @Override
        public Archive setOauthToken(java.lang.String oauthToken) {
          return (Archive) super.setOauthToken(oauthToken);
        }

        @Override
        public Archive setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Archive) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Archive setQuotaUser(java.lang.String quotaUser) {
          return (Archive) super.setQuotaUser(quotaUser);
        }

        @Override
        public Archive setUploadType(java.lang.String uploadType) {
          return (Archive) super.setUploadType(uploadType);
        }

        @Override
        public Archive setUploadProtocol(java.lang.String uploadProtocol) {
          return (Archive) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the CustomDimension to archive. Example format:
         * properties/1234/customDimensions/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the CustomDimension to archive. Example format:
       properties/1234/customDimensions/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the CustomDimension to archive. Example format:
         * properties/1234/customDimensions/5678
         */
        public Archive setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Archive set(String parameterName, Object value) {
          return (Archive) super.set(parameterName, value);
        }
      }
      /**
       * Creates a CustomDimension.
       *
       * Create a request for the method "customDimensions.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension> {

        private static final String REST_PATH = "v1beta/{+parent}/customDimensions";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a CustomDimension.
         *
         * Create a request for the method "customDimensions.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Lookup for a single CustomDimension.
       *
       * Create a request for the method "customDimensions.get".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the CustomDimension to get. Example format:
       *        properties/1234/customDimensions/5678
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customDimensions/[^/]+$");

        /**
         * Lookup for a single CustomDimension.
         *
         * Create a request for the method "customDimensions.get".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the CustomDimension to get. Example format:
       *        properties/1234/customDimensions/5678
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the CustomDimension to get. Example format:
         * properties/1234/customDimensions/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the CustomDimension to get. Example format:
       properties/1234/customDimensions/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the CustomDimension to get. Example format:
         * properties/1234/customDimensions/5678
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists CustomDimensions on a property.
       *
       * Create a request for the method "customDimensions.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListCustomDimensionsResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/customDimensions";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Lists CustomDimensions on a property.
         *
         * Create a request for the method "customDimensions.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListCustomDimensionsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. If unspecified, at most 50 resources will be returned.
       The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListCustomDimensions` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListCustomDimensions` must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListCustomDimensions` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListCustomDimensions` must
       match the call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListCustomDimensions` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListCustomDimensions` must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a CustomDimension on a property.
       *
       * Create a request for the method "customDimensions.patch".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Output only. Resource name for this CustomDimension resource. Format:
       *        properties/{property}/customDimensions/{customDimension}
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customDimensions/[^/]+$");

        /**
         * Updates a CustomDimension on a property.
         *
         * Create a request for the method "customDimensions.patch".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Output only. Resource name for this CustomDimension resource. Format:
       *        properties/{property}/customDimensions/{customDimension}
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension content) {
          super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomDimension.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Output only. Resource name for this CustomDimension resource. Format:
         * properties/{property}/customDimensions/{customDimension}
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Output only. Resource name for this CustomDimension resource. Format:
       properties/{property}/customDimensions/{customDimension}
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Output only. Resource name for this CustomDimension resource. Format:
         * properties/{property}/customDimensions/{customDimension}
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customDimensions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The list of fields to be updated. Omitted fields will not be updated. To replace the
       entire entity, use one path with the string "*" to match all fields.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the CustomMetrics collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.CustomMetrics.List request = analyticsadmin.customMetrics().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public CustomMetrics customMetrics() {
      return new CustomMetrics();
    }

    /**
     * The "customMetrics" collection of methods.
     */
    public class CustomMetrics {

      /**
       * Archives a CustomMetric on a property.
       *
       * Create a request for the method "customMetrics.archive".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Archive#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the CustomMetric to archive. Example format:
       *        properties/1234/customMetrics/5678
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest}
       * @return the request
       */
      public Archive archive(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest content) throws java.io.IOException {
        Archive result = new Archive(name, content);
        initialize(result);
        return result;
      }

      public class Archive extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}:archive";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customMetrics/[^/]+$");

        /**
         * Archives a CustomMetric on a property.
         *
         * Create a request for the method "customMetrics.archive".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Archive#execute()} method to invoke the remote operation.
         * <p> {@link
         * Archive#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the CustomMetric to archive. Example format:
       *        properties/1234/customMetrics/5678
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest}
         * @since 1.13
         */
        protected Archive(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaArchiveCustomMetricRequest content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
        }

        @Override
        public Archive set$Xgafv(java.lang.String $Xgafv) {
          return (Archive) super.set$Xgafv($Xgafv);
        }

        @Override
        public Archive setAccessToken(java.lang.String accessToken) {
          return (Archive) super.setAccessToken(accessToken);
        }

        @Override
        public Archive setAlt(java.lang.String alt) {
          return (Archive) super.setAlt(alt);
        }

        @Override
        public Archive setCallback(java.lang.String callback) {
          return (Archive) super.setCallback(callback);
        }

        @Override
        public Archive setFields(java.lang.String fields) {
          return (Archive) super.setFields(fields);
        }

        @Override
        public Archive setKey(java.lang.String key) {
          return (Archive) super.setKey(key);
        }

        @Override
        public Archive setOauthToken(java.lang.String oauthToken) {
          return (Archive) super.setOauthToken(oauthToken);
        }

        @Override
        public Archive setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Archive) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Archive setQuotaUser(java.lang.String quotaUser) {
          return (Archive) super.setQuotaUser(quotaUser);
        }

        @Override
        public Archive setUploadType(java.lang.String uploadType) {
          return (Archive) super.setUploadType(uploadType);
        }

        @Override
        public Archive setUploadProtocol(java.lang.String uploadProtocol) {
          return (Archive) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the CustomMetric to archive. Example format:
         * properties/1234/customMetrics/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the CustomMetric to archive. Example format:
       properties/1234/customMetrics/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the CustomMetric to archive. Example format:
         * properties/1234/customMetrics/5678
         */
        public Archive setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Archive set(String parameterName, Object value) {
          return (Archive) super.set(parameterName, value);
        }
      }
      /**
       * Creates a CustomMetric.
       *
       * Create a request for the method "customMetrics.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric> {

        private static final String REST_PATH = "v1beta/{+parent}/customMetrics";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a CustomMetric.
         *
         * Create a request for the method "customMetrics.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Lookup for a single CustomMetric.
       *
       * Create a request for the method "customMetrics.get".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the CustomMetric to get. Example format: properties/1234/customMetrics/5678
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customMetrics/[^/]+$");

        /**
         * Lookup for a single CustomMetric.
         *
         * Create a request for the method "customMetrics.get".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the CustomMetric to get. Example format: properties/1234/customMetrics/5678
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the CustomMetric to get. Example format:
         * properties/1234/customMetrics/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the CustomMetric to get. Example format: properties/1234/customMetrics/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the CustomMetric to get. Example format:
         * properties/1234/customMetrics/5678
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists CustomMetrics on a property.
       *
       * Create a request for the method "customMetrics.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListCustomMetricsResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/customMetrics";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Lists CustomMetrics on a property.
         *
         * Create a request for the method "customMetrics.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListCustomMetricsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. If unspecified, at most 50 resources will be returned.
       The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListCustomMetrics` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to
         * `ListCustomMetrics` must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListCustomMetrics` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListCustomMetrics` must match
       the call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListCustomMetrics` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to
         * `ListCustomMetrics` must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a CustomMetric on a property.
       *
       * Create a request for the method "customMetrics.patch".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Output only. Resource name for this CustomMetric resource. Format:
       *        properties/{property}/customMetrics/{customMetric}
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/customMetrics/[^/]+$");

        /**
         * Updates a CustomMetric on a property.
         *
         * Create a request for the method "customMetrics.patch".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Output only. Resource name for this CustomMetric resource. Format:
       *        properties/{property}/customMetrics/{customMetric}
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric content) {
          super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaCustomMetric.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Output only. Resource name for this CustomMetric resource. Format:
         * properties/{property}/customMetrics/{customMetric}
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Output only. Resource name for this CustomMetric resource. Format:
       properties/{property}/customMetrics/{customMetric}
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Output only. Resource name for this CustomMetric resource. Format:
         * properties/{property}/customMetrics/{customMetric}
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/customMetrics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The list of fields to be updated. Omitted fields will not be updated. To replace the
       entire entity, use one path with the string "*" to match all fields.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the DataStreams collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.DataStreams.List request = analyticsadmin.dataStreams().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DataStreams dataStreams() {
      return new DataStreams();
    }

    /**
     * The "dataStreams" collection of methods.
     */
    public class DataStreams {

      /**
       * Creates a DataStream.
       *
       * Create a request for the method "dataStreams.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream> {

        private static final String REST_PATH = "v1beta/{+parent}/dataStreams";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a DataStream.
         *
         * Create a request for the method "dataStreams.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a DataStream on a property.
       *
       * Create a request for the method "dataStreams.delete".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the DataStream to delete. Example format: properties/1234/dataStreams/5678
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+$");

        /**
         * Deletes a DataStream on a property.
         *
         * Create a request for the method "dataStreams.delete".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the DataStream to delete. Example format: properties/1234/dataStreams/5678
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the DataStream to delete. Example format:
         * properties/1234/dataStreams/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the DataStream to delete. Example format: properties/1234/dataStreams/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the DataStream to delete. Example format:
         * properties/1234/dataStreams/5678
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lookup for a single DataStream.
       *
       * Create a request for the method "dataStreams.get".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The name of the DataStream to get. Example format: properties/1234/dataStreams/5678
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+$");

        /**
         * Lookup for a single DataStream.
         *
         * Create a request for the method "dataStreams.get".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the DataStream to get. Example format: properties/1234/dataStreams/5678
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the DataStream to get. Example format:
         * properties/1234/dataStreams/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the DataStream to get. Example format: properties/1234/dataStreams/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the DataStream to get. Example format:
         * properties/1234/dataStreams/5678
         */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists DataStreams on a property.
       *
       * Create a request for the method "dataStreams.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListDataStreamsResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/dataStreams";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Lists DataStreams on a property.
         *
         * Create a request for the method "dataStreams.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListDataStreamsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. If unspecified, at most 50 resources will be returned.
       The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListDataStreams` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to `ListDataStreams`
         * must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListDataStreams` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListDataStreams` must match the
       call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListDataStreams` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to `ListDataStreams`
         * must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a DataStream on a property.
       *
       * Create a request for the method "dataStreams.patch".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Output only. Resource name of this Data Stream. Format:
       *        properties/{property_id}/dataStreams/{stream_id} Example:
       *        "properties/1000/dataStreams/2000"
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+$");

        /**
         * Updates a DataStream on a property.
         *
         * Create a request for the method "dataStreams.patch".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Output only. Resource name of this Data Stream. Format:
       *        properties/{property_id}/dataStreams/{stream_id} Example:
       *        "properties/1000/dataStreams/2000"
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream content) {
          super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaDataStream.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Output only. Resource name of this Data Stream. Format:
         * properties/{property_id}/dataStreams/{stream_id} Example:
         * "properties/1000/dataStreams/2000"
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Output only. Resource name of this Data Stream. Format:
       properties/{property_id}/dataStreams/{stream_id} Example: "properties/1000/dataStreams/2000"
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Output only. Resource name of this Data Stream. Format:
         * properties/{property_id}/dataStreams/{stream_id} Example:
         * "properties/1000/dataStreams/2000"
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/dataStreams/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The list of fields to be updated. Omitted fields will not be updated. To replace the
       entire entity, use one path with the string "*" to match all fields.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The list of fields to be updated. Omitted fields will not be updated. To
         * replace the entire entity, use one path with the string "*" to match all fields.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the MeasurementProtocolSecrets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
       *   {@code GoogleAnalyticsAdmin.MeasurementProtocolSecrets.List request = analyticsadmin.measurementProtocolSecrets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public MeasurementProtocolSecrets measurementProtocolSecrets() {
        return new MeasurementProtocolSecrets();
      }

      /**
       * The "measurementProtocolSecrets" collection of methods.
       */
      public class MeasurementProtocolSecrets {

        /**
         * Creates a measurement protocol secret.
         *
         * Create a request for the method "measurementProtocolSecrets.create".
         *
         * This request holds the parameters needed by the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The parent resource where this secret will be created. Format:
         *        properties/{property}/dataStreams/{dataStream}
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret> {

          private static final String REST_PATH = "v1beta/{+parent}/measurementProtocolSecrets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+$");

          /**
           * Creates a measurement protocol secret.
           *
           * Create a request for the method "measurementProtocolSecrets.create".
           *
           * This request holds the parameters needed by the the analyticsadmin server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The parent resource where this secret will be created. Format:
         *        properties/{property}/dataStreams/{dataStream}
           * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret content) {
            super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The parent resource where this secret will be created. Format:
           * properties/{property}/dataStreams/{dataStream}
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The parent resource where this secret will be created. Format:
         properties/{property}/dataStreams/{dataStream}
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The parent resource where this secret will be created. Format:
           * properties/{property}/dataStreams/{dataStream}
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes target MeasurementProtocolSecret.
         *
         * Create a request for the method "measurementProtocolSecrets.delete".
         *
         * This request holds the parameters needed by the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{property}/dataStr
         *        eams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

          private static final String REST_PATH = "v1beta/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");

          /**
           * Deletes target MeasurementProtocolSecret.
           *
           * Create a request for the method "measurementProtocolSecrets.delete".
           *
           * This request holds the parameters needed by the the analyticsadmin server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{property}/dataStr
         *        eams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{prop
           * erty}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{property}/dataSt
         reams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{prop
           * erty}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Lookup for a single "GA4" MeasurementProtocolSecret.
         *
         * Create a request for the method "measurementProtocolSecrets.get".
         *
         * This request holds the parameters needed by the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the measurement protocol secret to lookup. Format: properties/{property}/dataS
         *        treams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret> {

          private static final String REST_PATH = "v1beta/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");

          /**
           * Lookup for a single "GA4" MeasurementProtocolSecret.
           *
           * Create a request for the method "measurementProtocolSecrets.get".
           *
           * This request holds the parameters needed by the the analyticsadmin server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the measurement protocol secret to lookup. Format: properties/{property}/dataS
         *        treams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The name of the measurement protocol secret to lookup. Format: properties/{pr
           * operty}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the measurement protocol secret to lookup. Format: properties/{property}/data
         Streams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. The name of the measurement protocol secret to lookup. Format: properties/{pr
           * operty}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Returns child MeasurementProtocolSecrets under the specified parent Property.
         *
         * Create a request for the method "measurementProtocolSecrets.list".
         *
         * This request holds the parameters needed by the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The resource name of the parent stream. Format:
         *        properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse> {

          private static final String REST_PATH = "v1beta/{+parent}/measurementProtocolSecrets";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+$");

          /**
           * Returns child MeasurementProtocolSecrets under the specified parent Property.
           *
           * Create a request for the method "measurementProtocolSecrets.list".
           *
           * This request holds the parameters needed by the the analyticsadmin server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The resource name of the parent stream. Format:
         *        properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListMeasurementProtocolSecretsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the parent stream. Format:
           * properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The resource name of the parent stream. Format:
         properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The resource name of the parent stream. Format:
           * properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * The maximum number of resources to return. If unspecified, at most 10 resources will be
           * returned. The maximum value is 10. Higher values will be coerced to the maximum.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of resources to return. If unspecified, at most 10 resources will be returned.
         The maximum value is 10. Higher values will be coerced to the maximum.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of resources to return. If unspecified, at most 10 resources will be
           * returned. The maximum value is 10. Higher values will be coerced to the maximum.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A page token, received from a previous `ListMeasurementProtocolSecrets` call. Provide
           * this to retrieve the subsequent page. When paginating, all other parameters provided to
           * `ListMeasurementProtocolSecrets` must match the call that provided the page token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A page token, received from a previous `ListMeasurementProtocolSecrets` call. Provide this to
         retrieve the subsequent page. When paginating, all other parameters provided to
         `ListMeasurementProtocolSecrets` must match the call that provided the page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A page token, received from a previous `ListMeasurementProtocolSecrets` call. Provide
           * this to retrieve the subsequent page. When paginating, all other parameters provided to
           * `ListMeasurementProtocolSecrets` must match the call that provided the page token.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates a measurement protocol secret.
         *
         * Create a request for the method "measurementProtocolSecrets.patch".
         *
         * This request holds the parameters needed by the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name Output only. Resource name of this secret. This secret may be a child of any type of stream. Format:
         *        properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProt
         *        ocolSecret}
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret> {

          private static final String REST_PATH = "v1beta/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");

          /**
           * Updates a measurement protocol secret.
           *
           * Create a request for the method "measurementProtocolSecrets.patch".
           *
           * This request holds the parameters needed by the the analyticsadmin server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Output only. Resource name of this secret. This secret may be a child of any type of stream. Format:
         *        properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProt
         *        ocolSecret}
           * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret content) {
            super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaMeasurementProtocolSecret.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Output only. Resource name of this secret. This secret may be a child of any type of
           * stream. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecre
           * ts/{measurementProtocolSecret}
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Output only. Resource name of this secret. This secret may be a child of any type of stream.
         Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProto
         colSecret}
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Output only. Resource name of this secret. This secret may be a child of any type of
           * stream. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecre
           * ts/{measurementProtocolSecret}
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /** The list of fields to be updated. Omitted fields will not be updated. */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The list of fields to be updated. Omitted fields will not be updated.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /** The list of fields to be updated. Omitted fields will not be updated. */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the FirebaseLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.FirebaseLinks.List request = analyticsadmin.firebaseLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public FirebaseLinks firebaseLinks() {
      return new FirebaseLinks();
    }

    /**
     * The "firebaseLinks" collection of methods.
     */
    public class FirebaseLinks {

      /**
       * Creates a FirebaseLink. Properties can have at most one FirebaseLink.
       *
       * Create a request for the method "firebaseLinks.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Format: properties/{property_id} Example: properties/1234
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink> {

        private static final String REST_PATH = "v1beta/{+parent}/firebaseLinks";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a FirebaseLink. Properties can have at most one FirebaseLink.
         *
         * Create a request for the method "firebaseLinks.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Format: properties/{property_id} Example: properties/1234
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaFirebaseLink.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Format: properties/{property_id} Example: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Format: properties/{property_id} Example: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Format: properties/{property_id} Example: properties/1234 */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a FirebaseLink on a property
       *
       * Create a request for the method "firebaseLinks.delete".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
       *        properties/1234/firebaseLinks/5678
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/firebaseLinks/[^/]+$");

        /**
         * Deletes a FirebaseLink on a property
         *
         * Create a request for the method "firebaseLinks.delete".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
       *        properties/1234/firebaseLinks/5678
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/firebaseLinks/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
         * properties/1234/firebaseLinks/5678
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
       properties/1234/firebaseLinks/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
         * properties/1234/firebaseLinks/5678
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/firebaseLinks/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists FirebaseLinks on a property. Properties can have at most one FirebaseLink.
       *
       * Create a request for the method "firebaseLinks.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Format: properties/{property_id} Example: properties/1234
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListFirebaseLinksResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/firebaseLinks";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Lists FirebaseLinks on a property. Properties can have at most one FirebaseLink.
         *
         * Create a request for the method "firebaseLinks.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Format: properties/{property_id} Example: properties/1234
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListFirebaseLinksResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Format: properties/{property_id} Example: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Format: properties/{property_id} Example: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Format: properties/{property_id} Example: properties/1234 */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. The service may return fewer than this value,
         * even if there are additional pages. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200; (higher values will be coerced to the maximum)
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. The service may return fewer than this value, even if
       there are additional pages. If unspecified, at most 50 resources will be returned. The maximum
       value is 200; (higher values will be coerced to the maximum)
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. The service may return fewer than this value,
         * even if there are additional pages. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200; (higher values will be coerced to the maximum)
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListFirebaseLinks` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to
         * `ListFirebaseLinks` must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListFirebaseLinks` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListFirebaseLinks` must match
       the call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListFirebaseLinks` call. Provide this to retrieve
         * the subsequent page. When paginating, all other parameters provided to
         * `ListFirebaseLinks` must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the GoogleAdsLinks collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code GoogleAnalyticsAdmin analyticsadmin = new GoogleAnalyticsAdmin(...);}
     *   {@code GoogleAnalyticsAdmin.GoogleAdsLinks.List request = analyticsadmin.googleAdsLinks().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public GoogleAdsLinks googleAdsLinks() {
      return new GoogleAdsLinks();
    }

    /**
     * The "googleAdsLinks" collection of methods.
     */
    public class GoogleAdsLinks {

      /**
       * Creates a GoogleAdsLink.
       *
       * Create a request for the method "googleAdsLinks.create".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink> {

        private static final String REST_PATH = "v1beta/{+parent}/googleAdsLinks";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Creates a GoogleAdsLink.
         *
         * Create a request for the method "googleAdsLinks.create".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink content) {
          super(GoogleAnalyticsAdmin.this, "POST", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a GoogleAdsLink on a property
       *
       * Create a request for the method "googleAdsLinks.delete".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name Required. Example format: properties/1234/googleAdsLinks/5678
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/googleAdsLinks/[^/]+$");

        /**
         * Deletes a GoogleAdsLink on a property
         *
         * Create a request for the method "googleAdsLinks.delete".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Example format: properties/1234/googleAdsLinks/5678
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(GoogleAnalyticsAdmin.this, "DELETE", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleProtobufEmpty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/googleAdsLinks/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234/googleAdsLinks/5678 */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Example format: properties/1234/googleAdsLinks/5678
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. Example format: properties/1234/googleAdsLinks/5678 */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/googleAdsLinks/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists GoogleAdsLinks on a property.
       *
       * Create a request for the method "googleAdsLinks.list".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent Required. Example format: properties/1234
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse> {

        private static final String REST_PATH = "v1beta/{+parent}/googleAdsLinks";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+$");

        /**
         * Lists GoogleAdsLinks on a property.
         *
         * Create a request for the method "googleAdsLinks.list".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. Example format: properties/1234
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(GoogleAnalyticsAdmin.this, "GET", REST_PATH, null, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaListGoogleAdsLinksResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. Example format: properties/1234 */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. Example format: properties/1234
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** Required. Example format: properties/1234 */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^properties/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of resources to return. If unspecified, at most 50 resources will be returned.
       The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of resources to return. If unspecified, at most 50 resources will be
         * returned. The maximum value is 200 (higher values will be coerced to the maximum).
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token, received from a previous `ListGoogleAdsLinks` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListGoogleAdsLinks` must match the call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token, received from a previous `ListGoogleAdsLinks` call. Provide this to retrieve the
       subsequent page. When paginating, all other parameters provided to `ListGoogleAdsLinks` must match
       the call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token, received from a previous `ListGoogleAdsLinks` call. Provide this to
         * retrieve the subsequent page. When paginating, all other parameters provided to
         * `ListGoogleAdsLinks` must match the call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a GoogleAdsLink on a property
       *
       * Create a request for the method "googleAdsLinks.patch".
       *
       * This request holds the parameters needed by the analyticsadmin server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note: googleAdsLinkId
       *        is not the Google Ads customer ID.
       * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends GoogleAnalyticsAdminRequest<com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink> {

        private static final String REST_PATH = "v1beta/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^properties/[^/]+/googleAdsLinks/[^/]+$");

        /**
         * Updates a GoogleAdsLink on a property
         *
         * Create a request for the method "googleAdsLinks.patch".
         *
         * This request holds the parameters needed by the the analyticsadmin server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note: googleAdsLinkId
       *        is not the Google Ads customer ID.
         * @param content the {@link com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink content) {
          super(GoogleAnalyticsAdmin.this, "PATCH", REST_PATH, content, com.google.api.services.analyticsadmin.v1beta.model.GoogleAnalyticsAdminV1betaGoogleAdsLink.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/googleAdsLinks/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
         * googleAdsLinkId is not the Google Ads customer ID.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note: googleAdsLinkId
       is not the Google Ads customer ID.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
         * googleAdsLinkId is not the Google Ads customer ID.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^properties/[^/]+/googleAdsLinks/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
         * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
         * one path with the string "*" to match all fields.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The list of fields to be updated. Field names must be in snake case (e.g.,
       "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use one path
       with the string "*" to match all fields.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The list of fields to be updated. Field names must be in snake case (e.g.,
         * "field_to_update"). Omitted fields will not be updated. To replace the entire entity, use
         * one path with the string "*" to match all fields.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link GoogleAnalyticsAdmin}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link GoogleAnalyticsAdmin}. */
    @Override
    public GoogleAnalyticsAdmin build() {
      return new GoogleAnalyticsAdmin(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link GoogleAnalyticsAdminRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setGoogleAnalyticsAdminRequestInitializer(
        GoogleAnalyticsAdminRequestInitializer googleanalyticsadminRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleanalyticsadminRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
