/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A resource message representing a Google Analytics account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaAccount extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Time when this account was originally created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. Indicates whether this Account is soft-deleted or not. Deleted accounts are
   * excluded from List results unless specifically requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Required. Human-readable display name for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Country of business. Must be a Unicode CLDR region code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * Output only. Time when account payload fields were last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. Time when this account was originally created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when this account was originally created.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. Indicates whether this Account is soft-deleted or not. Deleted accounts are
   * excluded from List results unless specifically requested.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. Indicates whether this Account is soft-deleted or not. Deleted accounts are
   * excluded from List results unless specifically requested.
   * @param deleted deleted or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Required. Human-readable display name for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Required. Human-readable display name for this account.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of this account. Format: accounts/{account} Example: "accounts/100"
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Country of business. Must be a Unicode CLDR region code.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * Country of business. Must be a Unicode CLDR region code.
   * @param regionCode regionCode or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  /**
   * Output only. Time when account payload fields were last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time when account payload fields were last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaAccount set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaAccount) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaAccount clone() {
    return (GoogleAnalyticsAdminV1betaAccount) super.clone();
  }

}
