/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A snapshot of a resource as before or after the result of a change in change history.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource extends com.google.api.client.json.GenericJson {

  /**
   * A snapshot of an Account resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaAccount account;

  /**
   * A snapshot of a ConversionEvent resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaConversionEvent conversionEvent;

  /**
   * A snapshot of a data retention settings resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaDataRetentionSettings dataRetentionSettings;

  /**
   * A snapshot of a DataStream resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaDataStream dataStream;

  /**
   * A snapshot of a FirebaseLink resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaFirebaseLink firebaseLink;

  /**
   * A snapshot of a GoogleAdsLink resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaGoogleAdsLink googleAdsLink;

  /**
   * A snapshot of a MeasurementProtocolSecret resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaMeasurementProtocolSecret measurementProtocolSecret;

  /**
   * A snapshot of a Property resource in change history.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsAdminV1betaProperty property;

  /**
   * A snapshot of an Account resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaAccount getAccount() {
    return account;
  }

  /**
   * A snapshot of an Account resource in change history.
   * @param account account or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setAccount(GoogleAnalyticsAdminV1betaAccount account) {
    this.account = account;
    return this;
  }

  /**
   * A snapshot of a ConversionEvent resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent getConversionEvent() {
    return conversionEvent;
  }

  /**
   * A snapshot of a ConversionEvent resource in change history.
   * @param conversionEvent conversionEvent or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setConversionEvent(GoogleAnalyticsAdminV1betaConversionEvent conversionEvent) {
    this.conversionEvent = conversionEvent;
    return this;
  }

  /**
   * A snapshot of a data retention settings resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataRetentionSettings getDataRetentionSettings() {
    return dataRetentionSettings;
  }

  /**
   * A snapshot of a data retention settings resource in change history.
   * @param dataRetentionSettings dataRetentionSettings or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setDataRetentionSettings(GoogleAnalyticsAdminV1betaDataRetentionSettings dataRetentionSettings) {
    this.dataRetentionSettings = dataRetentionSettings;
    return this;
  }

  /**
   * A snapshot of a DataStream resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataStream getDataStream() {
    return dataStream;
  }

  /**
   * A snapshot of a DataStream resource in change history.
   * @param dataStream dataStream or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setDataStream(GoogleAnalyticsAdminV1betaDataStream dataStream) {
    this.dataStream = dataStream;
    return this;
  }

  /**
   * A snapshot of a FirebaseLink resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaFirebaseLink getFirebaseLink() {
    return firebaseLink;
  }

  /**
   * A snapshot of a FirebaseLink resource in change history.
   * @param firebaseLink firebaseLink or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setFirebaseLink(GoogleAnalyticsAdminV1betaFirebaseLink firebaseLink) {
    this.firebaseLink = firebaseLink;
    return this;
  }

  /**
   * A snapshot of a GoogleAdsLink resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaGoogleAdsLink getGoogleAdsLink() {
    return googleAdsLink;
  }

  /**
   * A snapshot of a GoogleAdsLink resource in change history.
   * @param googleAdsLink googleAdsLink or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setGoogleAdsLink(GoogleAnalyticsAdminV1betaGoogleAdsLink googleAdsLink) {
    this.googleAdsLink = googleAdsLink;
    return this;
  }

  /**
   * A snapshot of a MeasurementProtocolSecret resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaMeasurementProtocolSecret getMeasurementProtocolSecret() {
    return measurementProtocolSecret;
  }

  /**
   * A snapshot of a MeasurementProtocolSecret resource in change history.
   * @param measurementProtocolSecret measurementProtocolSecret or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setMeasurementProtocolSecret(GoogleAnalyticsAdminV1betaMeasurementProtocolSecret measurementProtocolSecret) {
    this.measurementProtocolSecret = measurementProtocolSecret;
    return this;
  }

  /**
   * A snapshot of a Property resource in change history.
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaProperty getProperty() {
    return property;
  }

  /**
   * A snapshot of a Property resource in change history.
   * @param property property or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource setProperty(GoogleAnalyticsAdminV1betaProperty property) {
    this.property = property;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource clone() {
    return (GoogleAnalyticsAdminV1betaChangeHistoryChangeChangeHistoryResource) super.clone();
  }

}
