/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A conversion event in a Google Analytics property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaConversionEvent extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Time when this conversion event was created in the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. If set to true, this conversion event refers to a custom event. If set to false,
   * this conversion event refers to a default event in GA. Default events typically have special
   * meaning in GA. Default events are usually created for you by the GA system, but in some cases
   * can be created by property admins. Custom events count towards the maximum number of custom
   * conversion events that may be created per property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean custom;

  /**
   * Output only. If set, this event can currently be deleted via DeleteConversionEvent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deletable;

  /**
   * Immutable. The event name for this conversion event. Examples: 'click', 'purchase'
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventName;

  /**
   * Output only. Resource name of this conversion event. Format:
   * properties/{property}/conversionEvents/{conversion_event}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Time when this conversion event was created in the property.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time when this conversion event was created in the property.
   * @param createTime createTime or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. If set to true, this conversion event refers to a custom event. If set to false,
   * this conversion event refers to a default event in GA. Default events typically have special
   * meaning in GA. Default events are usually created for you by the GA system, but in some cases
   * can be created by property admins. Custom events count towards the maximum number of custom
   * conversion events that may be created per property.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCustom() {
    return custom;
  }

  /**
   * Output only. If set to true, this conversion event refers to a custom event. If set to false,
   * this conversion event refers to a default event in GA. Default events typically have special
   * meaning in GA. Default events are usually created for you by the GA system, but in some cases
   * can be created by property admins. Custom events count towards the maximum number of custom
   * conversion events that may be created per property.
   * @param custom custom or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent setCustom(java.lang.Boolean custom) {
    this.custom = custom;
    return this;
  }

  /**
   * Output only. If set, this event can currently be deleted via DeleteConversionEvent.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeletable() {
    return deletable;
  }

  /**
   * Output only. If set, this event can currently be deleted via DeleteConversionEvent.
   * @param deletable deletable or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent setDeletable(java.lang.Boolean deletable) {
    this.deletable = deletable;
    return this;
  }

  /**
   * Immutable. The event name for this conversion event. Examples: 'click', 'purchase'
   * @return value or {@code null} for none
   */
  public java.lang.String getEventName() {
    return eventName;
  }

  /**
   * Immutable. The event name for this conversion event. Examples: 'click', 'purchase'
   * @param eventName eventName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent setEventName(java.lang.String eventName) {
    this.eventName = eventName;
    return this;
  }

  /**
   * Output only. Resource name of this conversion event. Format:
   * properties/{property}/conversionEvents/{conversion_event}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name of this conversion event. Format:
   * properties/{property}/conversionEvents/{conversion_event}
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaConversionEvent setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaConversionEvent set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaConversionEvent) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaConversionEvent clone() {
    return (GoogleAnalyticsAdminV1betaConversionEvent) super.clone();
  }

}
