/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A definition for a CustomDimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaCustomDimension extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Optional. If set to true, sets this dimension as NPA and excludes it from ads personalization.
   * This is currently only supported by user-scoped custom dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disallowAdsPersonalization;

  /**
   * Required. Display name for this custom dimension as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Resource name for this CustomDimension resource. Format:
   * properties/{property}/customDimensions/{customDimension}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Immutable. Tagging parameter name for this custom dimension. If this is a user-scoped
   * dimension, then this is the user property name. If this is an event-scoped dimension, then this
   * is the event parameter name. May only contain alphanumeric and underscore characters, starting
   * with a letter. Max length of 24 characters for user-scoped dimensions, 40 characters for event-
   * scoped dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameterName;

  /**
   * Required. Immutable. The scope of this dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scope;

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * @param description description or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Optional. If set to true, sets this dimension as NPA and excludes it from ads personalization.
   * This is currently only supported by user-scoped custom dimensions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisallowAdsPersonalization() {
    return disallowAdsPersonalization;
  }

  /**
   * Optional. If set to true, sets this dimension as NPA and excludes it from ads personalization.
   * This is currently only supported by user-scoped custom dimensions.
   * @param disallowAdsPersonalization disallowAdsPersonalization or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setDisallowAdsPersonalization(java.lang.Boolean disallowAdsPersonalization) {
    this.disallowAdsPersonalization = disallowAdsPersonalization;
    return this;
  }

  /**
   * Required. Display name for this custom dimension as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Required. Display name for this custom dimension as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Resource name for this CustomDimension resource. Format:
   * properties/{property}/customDimensions/{customDimension}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name for this CustomDimension resource. Format:
   * properties/{property}/customDimensions/{customDimension}
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Immutable. Tagging parameter name for this custom dimension. If this is a user-scoped
   * dimension, then this is the user property name. If this is an event-scoped dimension, then this
   * is the event parameter name. May only contain alphanumeric and underscore characters, starting
   * with a letter. Max length of 24 characters for user-scoped dimensions, 40 characters for event-
   * scoped dimensions.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameterName() {
    return parameterName;
  }

  /**
   * Required. Immutable. Tagging parameter name for this custom dimension. If this is a user-scoped
   * dimension, then this is the user property name. If this is an event-scoped dimension, then this
   * is the event parameter name. May only contain alphanumeric and underscore characters, starting
   * with a letter. Max length of 24 characters for user-scoped dimensions, 40 characters for event-
   * scoped dimensions.
   * @param parameterName parameterName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setParameterName(java.lang.String parameterName) {
    this.parameterName = parameterName;
    return this;
  }

  /**
   * Required. Immutable. The scope of this dimension.
   * @return value or {@code null} for none
   */
  public java.lang.String getScope() {
    return scope;
  }

  /**
   * Required. Immutable. The scope of this dimension.
   * @param scope scope or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomDimension setScope(java.lang.String scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaCustomDimension set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaCustomDimension) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaCustomDimension clone() {
    return (GoogleAnalyticsAdminV1betaCustomDimension) super.clone();
  }

}
