/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A definition for a custom metric.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaCustomMetric extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Required. Display name for this custom metric as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Required. The type for the custom metric's value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String measurementUnit;

  /**
   * Output only. Resource name for this CustomMetric resource. Format:
   * properties/{property}/customMetrics/{customMetric}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Immutable. Tagging name for this custom metric. If this is an event-scoped metric,
   * then this is the event parameter name. May only contain alphanumeric and underscore charactes,
   * starting with a letter. Max length of 40 characters for event-scoped metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameterName;

  /**
   * Optional. Types of restricted data that this metric may contain. Required for metrics with
   * CURRENCY measurement unit. Must be empty for metrics with a non-CURRENCY measurement unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> restrictedMetricType;

  /**
   * Required. Immutable. The scope of this custom metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scope;

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. Description for this custom dimension. Max length of 150 characters.
   * @param description description or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Required. Display name for this custom metric as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Required. Display name for this custom metric as shown in the Analytics UI. Max length of 82
   * characters, alphanumeric plus space and underscore starting with a letter. Legacy system-
   * generated display names may contain square brackets, but updates to this field will never
   * permit square brackets.
   * @param displayName displayName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Required. The type for the custom metric's value.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeasurementUnit() {
    return measurementUnit;
  }

  /**
   * Required. The type for the custom metric's value.
   * @param measurementUnit measurementUnit or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setMeasurementUnit(java.lang.String measurementUnit) {
    this.measurementUnit = measurementUnit;
    return this;
  }

  /**
   * Output only. Resource name for this CustomMetric resource. Format:
   * properties/{property}/customMetrics/{customMetric}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name for this CustomMetric resource. Format:
   * properties/{property}/customMetrics/{customMetric}
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Immutable. Tagging name for this custom metric. If this is an event-scoped metric,
   * then this is the event parameter name. May only contain alphanumeric and underscore charactes,
   * starting with a letter. Max length of 40 characters for event-scoped metrics.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameterName() {
    return parameterName;
  }

  /**
   * Required. Immutable. Tagging name for this custom metric. If this is an event-scoped metric,
   * then this is the event parameter name. May only contain alphanumeric and underscore charactes,
   * starting with a letter. Max length of 40 characters for event-scoped metrics.
   * @param parameterName parameterName or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setParameterName(java.lang.String parameterName) {
    this.parameterName = parameterName;
    return this;
  }

  /**
   * Optional. Types of restricted data that this metric may contain. Required for metrics with
   * CURRENCY measurement unit. Must be empty for metrics with a non-CURRENCY measurement unit.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRestrictedMetricType() {
    return restrictedMetricType;
  }

  /**
   * Optional. Types of restricted data that this metric may contain. Required for metrics with
   * CURRENCY measurement unit. Must be empty for metrics with a non-CURRENCY measurement unit.
   * @param restrictedMetricType restrictedMetricType or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setRestrictedMetricType(java.util.List<java.lang.String> restrictedMetricType) {
    this.restrictedMetricType = restrictedMetricType;
    return this;
  }

  /**
   * Required. Immutable. The scope of this custom metric.
   * @return value or {@code null} for none
   */
  public java.lang.String getScope() {
    return scope;
  }

  /**
   * Required. Immutable. The scope of this custom metric.
   * @param scope scope or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaCustomMetric setScope(java.lang.String scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaCustomMetric set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaCustomMetric) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaCustomMetric clone() {
    return (GoogleAnalyticsAdminV1betaCustomMetric) super.clone();
  }

}
