/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * Settings values for data retention. This is a singleton resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataRetentionSettings extends com.google.api.client.json.GenericJson {

  /**
   * The length of time that event-level data is retained.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventDataRetention;

  /**
   * Output only. Resource name for this DataRetentionSetting resource. Format:
   * properties/{property}/dataRetentionSettings
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * If true, reset the retention period for the user identifier with every event from that user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean resetUserDataOnNewActivity;

  /**
   * The length of time that event-level data is retained.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventDataRetention() {
    return eventDataRetention;
  }

  /**
   * The length of time that event-level data is retained.
   * @param eventDataRetention eventDataRetention or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataRetentionSettings setEventDataRetention(java.lang.String eventDataRetention) {
    this.eventDataRetention = eventDataRetention;
    return this;
  }

  /**
   * Output only. Resource name for this DataRetentionSetting resource. Format:
   * properties/{property}/dataRetentionSettings
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name for this DataRetentionSetting resource. Format:
   * properties/{property}/dataRetentionSettings
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataRetentionSettings setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * If true, reset the retention period for the user identifier with every event from that user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getResetUserDataOnNewActivity() {
    return resetUserDataOnNewActivity;
  }

  /**
   * If true, reset the retention period for the user identifier with every event from that user.
   * @param resetUserDataOnNewActivity resetUserDataOnNewActivity or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataRetentionSettings setResetUserDataOnNewActivity(java.lang.Boolean resetUserDataOnNewActivity) {
    this.resetUserDataOnNewActivity = resetUserDataOnNewActivity;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataRetentionSettings set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataRetentionSettings) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataRetentionSettings clone() {
    return (GoogleAnalyticsAdminV1betaDataRetentionSettings) super.clone();
  }

}
