/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsadmin.v1beta.model;

/**
 * A resource message representing data sharing settings of a Google Analytics account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Admin API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAnalyticsAdminV1betaDataSharingSettings extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Resource name. Format: accounts/{account}/dataSharingSettings Example:
   * "accounts/1000/dataSharingSettings"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Allows any of Google sales to access the data in order to suggest configuration changes to
   * improve results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharingWithGoogleAnySalesEnabled;

  /**
   * Allows Google sales teams that are assigned to the customer to access the data in order to
   * suggest configuration changes to improve results. Sales team restrictions still apply when
   * enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharingWithGoogleAssignedSalesEnabled;

  /**
   * Allows Google to use the data to improve other Google products or services.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharingWithGoogleProductsEnabled;

  /**
   * Allows Google support to access the data in order to help troubleshoot issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharingWithGoogleSupportEnabled;

  /**
   * Allows Google to share the data anonymously in aggregate form with others.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharingWithOthersEnabled;

  /**
   * Output only. Resource name. Format: accounts/{account}/dataSharingSettings Example:
   * "accounts/1000/dataSharingSettings"
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Resource name. Format: accounts/{account}/dataSharingSettings Example:
   * "accounts/1000/dataSharingSettings"
   * @param name name or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Allows any of Google sales to access the data in order to suggest configuration changes to
   * improve results.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharingWithGoogleAnySalesEnabled() {
    return sharingWithGoogleAnySalesEnabled;
  }

  /**
   * Allows any of Google sales to access the data in order to suggest configuration changes to
   * improve results.
   * @param sharingWithGoogleAnySalesEnabled sharingWithGoogleAnySalesEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setSharingWithGoogleAnySalesEnabled(java.lang.Boolean sharingWithGoogleAnySalesEnabled) {
    this.sharingWithGoogleAnySalesEnabled = sharingWithGoogleAnySalesEnabled;
    return this;
  }

  /**
   * Allows Google sales teams that are assigned to the customer to access the data in order to
   * suggest configuration changes to improve results. Sales team restrictions still apply when
   * enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharingWithGoogleAssignedSalesEnabled() {
    return sharingWithGoogleAssignedSalesEnabled;
  }

  /**
   * Allows Google sales teams that are assigned to the customer to access the data in order to
   * suggest configuration changes to improve results. Sales team restrictions still apply when
   * enabled.
   * @param sharingWithGoogleAssignedSalesEnabled sharingWithGoogleAssignedSalesEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setSharingWithGoogleAssignedSalesEnabled(java.lang.Boolean sharingWithGoogleAssignedSalesEnabled) {
    this.sharingWithGoogleAssignedSalesEnabled = sharingWithGoogleAssignedSalesEnabled;
    return this;
  }

  /**
   * Allows Google to use the data to improve other Google products or services.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharingWithGoogleProductsEnabled() {
    return sharingWithGoogleProductsEnabled;
  }

  /**
   * Allows Google to use the data to improve other Google products or services.
   * @param sharingWithGoogleProductsEnabled sharingWithGoogleProductsEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setSharingWithGoogleProductsEnabled(java.lang.Boolean sharingWithGoogleProductsEnabled) {
    this.sharingWithGoogleProductsEnabled = sharingWithGoogleProductsEnabled;
    return this;
  }

  /**
   * Allows Google support to access the data in order to help troubleshoot issues.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharingWithGoogleSupportEnabled() {
    return sharingWithGoogleSupportEnabled;
  }

  /**
   * Allows Google support to access the data in order to help troubleshoot issues.
   * @param sharingWithGoogleSupportEnabled sharingWithGoogleSupportEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setSharingWithGoogleSupportEnabled(java.lang.Boolean sharingWithGoogleSupportEnabled) {
    this.sharingWithGoogleSupportEnabled = sharingWithGoogleSupportEnabled;
    return this;
  }

  /**
   * Allows Google to share the data anonymously in aggregate form with others.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharingWithOthersEnabled() {
    return sharingWithOthersEnabled;
  }

  /**
   * Allows Google to share the data anonymously in aggregate form with others.
   * @param sharingWithOthersEnabled sharingWithOthersEnabled or {@code null} for none
   */
  public GoogleAnalyticsAdminV1betaDataSharingSettings setSharingWithOthersEnabled(java.lang.Boolean sharingWithOthersEnabled) {
    this.sharingWithOthersEnabled = sharingWithOthersEnabled;
    return this;
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataSharingSettings set(String fieldName, Object value) {
    return (GoogleAnalyticsAdminV1betaDataSharingSettings) super.set(fieldName, value);
  }

  @Override
  public GoogleAnalyticsAdminV1betaDataSharingSettings clone() {
    return (GoogleAnalyticsAdminV1betaDataSharingSettings) super.clone();
  }

}
